<?php
require_once '../../../auth/check_session.php';
require_once '../../../config/database.php';

try {
    $db = getDatabaseConnection();
    
    $sql = "SELECT id, name, phone FROM customers 
            WHERE shop_id = ? OR shop_id IS NULL
            ORDER BY name";
    
    $stmt = $db->prepare($sql);
    $stmt->execute([$_SESSION['user']['shop_id']]);
    $customers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode($customers);
    
} catch (PDOException $e) {
    echo json_encode([]);
}
?>