<?php
session_start();
require_once '../../assets/db_connect.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user']['id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit();
}

$product_id = $_POST['id'] ?? 0;
$product_id = intval($product_id);

// Update product to inactive
$sql = "UPDATE products SET is_active = 0 WHERE id = ?";
$stmt = $pdo->prepare($sql);
$success = $stmt->execute([$product_id]);

if ($success) {
    echo json_encode([
        'status' => 'success', 
        'message' => 'Product deactivated successfully'
    ]);
} else {
    echo json_encode([
        'status' => 'error', 
        'message' => 'Failed to deactivate product'
    ]);
}
?>