<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role']!=='admin') { echo "Access denied"; exit; }

$from = $_GET['from'] ?? date('Y-m-d', strtotime('-6 months'));
$to   = $_GET['to'] ?? date('Y-m-d');
$limit = intval($_GET['limit'] ?? 50);

$sql = "
 SELECT p.id, p.name, COALESCE(SUM(sl.qty),0) AS total_qty
 FROM products p
 LEFT JOIN sale_lines sl ON sl.product_id = p.id
 LEFT JOIN sales s ON s.id = sl.sale_id AND DATE(s.sale_date) BETWEEN ? AND ?
 GROUP BY p.id
 ORDER BY total_qty ASC
 LIMIT ?
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$from,$to,$limit]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

// CSV export
if (isset($_GET['export']) && $_GET['export']==='csv') {
    header('Content-Type: text/csv'); header('Content-Disposition: attachment; filename=slow_moving_'.$from.'_'.$to.'.csv');
    $out = fopen('php://output','w');
    fputcsv($out, ['product_id','product_name','total_qty']);
    foreach ($rows as $r) fputcsv($out, [$r['id'],$r['name'],$r['total_qty']]);
    fclose($out); exit;
}
?>

<style>
/* Back button styling - consistent with other pages */
.back-btn {
    display: inline-block;
    padding: 8px 16px;
    background-color: #6c757d;
    color: white;
    text-decoration: none;
    border-radius: 4px;
    border: none;
    cursor: pointer;
    font-size: 14px;
    margin-bottom: 15px;
    transition: background-color 0.2s;
}
.back-btn:hover {
    background-color: #5a6268;
    color: white;
    text-decoration: none;
}
.back-btn i {
    margin-right: 5px;
}
/* Styling for zero sales */
.zero-sales {
    background-color: #f8d7da;
    color: #721c24;
}
</style>

<div class="col-md-10 ml-sm-auto px-4 py-4">

<!-- BACK BUTTON at the top -->
<div class="mb-3">
    <a href="daily_sales.php" class="back-btn">
        <i>←</i> Back to Reports
    </a>
</div>

<h3 class="text-success">Slow Moving Drugs</h3>

<form class="form-inline mb-3">
  <label class="mr-2">From</label><input type="date" name="from" value="<?= $from ?>" class="form-control mr-2">
  <label class="mr-2">To</label><input type="date" name="to" value="<?= $to ?>" class="form-control mr-2">
  <label class="mr-2">Limit</label><input type="number" name="limit" value="<?= $limit ?>" class="form-control mr-2" style="width:80px;">
  <button class="btn btn-primary mr-2">Filter</button>
  <a href="?from=<?= $from ?>&to=<?= $to ?>&limit=<?= $limit ?>&export=csv" 
     class="btn btn-outline-secondary mr-2">
     Export CSV
  </a>
</form>

<div class="table-responsive">
<table class="table table-sm table-bordered">
  <thead class="thead-dark"><tr><th>#</th><th>Product</th><th>Qty Sold</th></tr></thead>
  <tbody>
  <?php 
  $i=1; 
  $total_qty = 0;
  $zero_count = 0;
  foreach($rows as $r): 
    $total_qty += $r['total_qty'];
    if ($r['total_qty'] == 0) $zero_count++;
  ?>
    <tr class="<?= $r['total_qty'] == 0 ? 'zero-sales' : '' ?>">
      <td><?= $i++ ?></td>
      <td><?= htmlspecialchars($r['name']) ?></td>
      <td><?= $r['total_qty'] ?></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
  <tfoot>
    <tr class="table-secondary">
      <td colspan="2" class="text-right"><strong>Summary:</strong></td>
      <td>
        <div><strong>Total Sold: <?= $total_qty ?></strong></div>
        <div class="small text-muted">Zero sales items: <?= $zero_count ?></div>
      </td>
    </tr>
  </tfoot>
</table>
</div>

<!-- BACK BUTTON at the bottom -->
<div class="mt-4">
    <a href="daily_sales.php" class="back-btn">
        <i>←</i> Back to Reports
    </a>
</div>

</div>

<?php require_once '../includes/footer.php'; ?>