<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role']!=='admin') { echo "Access denied"; exit; }

$from = $_GET['from'] ?? date('Y-m-01');
$to   = $_GET['to'] ?? date('Y-m-d');

$sql = "
 SELECT 
   SUM(sl.line_total) AS revenue,
   SUM(pb.cost_price * sl.qty) AS cost,
   SUM(sl.line_total) - SUM(pb.cost_price * sl.qty) AS profit
 FROM sale_lines sl
 JOIN sales s ON s.id = sl.sale_id
 LEFT JOIN product_batches pb ON pb.id = sl.batch_id
 WHERE DATE(s.sale_date) BETWEEN ? AND ?
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$from,$to]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<style>
/* Back button styling - consistent with other pages */
.back-btn {
    display: inline-block;
    padding: 8px 16px;
    background-color: #6c757d;
    color: white;
    text-decoration: none;
    border-radius: 4px;
    border: none;
    cursor: pointer;
    font-size: 14px;
    margin-bottom: 15px;
    transition: background-color 0.2s;
}
.back-btn:hover {
    background-color: #5a6268;
    color: white;
    text-decoration: none;
}
.back-btn i {
    margin-right: 5px;
}
/* Profit/Loss styling */
.profit-positive {
    color: #28a745;
    font-weight: bold;
}
.profit-negative {
    color: #dc3545;
    font-weight: bold;
}
.profit-zero {
    color: #6c757d;
    font-weight: bold;
}
</style>

<div class="col-md-10 ml-sm-auto px-4 py-4">

<!-- BACK BUTTON at the top -->
<div class="mb-3">
    <a href="daily_sales.php" class="back-btn">
        <i>←</i> Back to Reports
    </a>
</div>

<h3 class="text-success">Profit Summary</h3>

<form class="form-inline mb-4">
  <label class="mr-2"><strong>From:</strong></label>
  <input type="date" name="from" value="<?= $from ?>" class="form-control mr-3">
  <label class="mr-2"><strong>To:</strong></label>
  <input type="date" name="to" value="<?= $to ?>" class="form-control mr-3">
  <button class="btn btn-primary">Filter</button>
</form>

<div class="row">
    <div class="col-md-8">
        <table class="table table-bordered">
            <tr>
                <th class="bg-light" style="width: 30%;">Revenue</th>
                <td style="width: 70%;"><?= number_format($row['revenue'] ?? 0,2) ?></td>
            </tr>
            <tr>
                <th class="bg-light">Cost</th>
                <td><?= number_format($row['cost'] ?? 0,2) ?></td>
            </tr>
            <tr>
                <th class="bg-light">Profit/Loss</th>
                <td>
                    <?php 
                    $profit = $row['profit'] ?? 0;
                    $profit_class = ($profit > 0) ? 'profit-positive' : (($profit < 0) ? 'profit-negative' : 'profit-zero');
                    ?>
                    <span class="<?= $profit_class ?>">
                        <?= number_format($profit,2) ?>
                    </span>
                </td>
            </tr>
        </table>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header bg-info text-white">
                <h6 class="mb-0">Summary</h6>
            </div>
            <div class="card-body">
                <p><strong>Date Range:</strong><br>
                <?= date('d M Y', strtotime($from)) ?> to <?= date('d M Y', strtotime($to)) ?></p>
                
                <p><strong>Profit Margin:</strong><br>
                <?php 
                $revenue = $row['revenue'] ?? 0;
                $profit = $row['profit'] ?? 0;
                $margin = ($revenue > 0) ? ($profit / $revenue) * 100 : 0;
                ?>
                <span class="<?= $margin >= 0 ? 'profit-positive' : 'profit-negative' ?>">
                    <?= number_format($margin, 2) ?>%
                </span>
                </p>
                
                <p><strong>Days in Period:</strong><br>
                <?= round((strtotime($to) - strtotime($from)) / (60 * 60 * 24)) + 1 ?> days</p>
            </div>
        </div>
    </div>
</div>

<!-- BACK BUTTON at the bottom -->
<div class="mt-4">
    <a href="daily_sales.php" class="back-btn">
        <i>←</i> Back to Reports
    </a>
</div>

</div>

<?php require_once '../includes/footer.php'; ?>