<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
if (!isset($_SESSION['user']) || $_SESSION['user']['role']!=='admin') { echo "Access denied"; exit; }

$from = $_GET['from'] ?? date('Y-m-01');
$to   = $_GET['to'] ?? date('Y-m-d');
$limit = intval($_GET['limit'] ?? 20);

$sql = "
 SELECT p.id, p.name, SUM(sl.qty) AS total_qty, SUM(sl.line_total) AS revenue
 FROM sale_lines sl
 JOIN sales s ON s.id = sl.sale_id
 JOIN products p ON p.id = sl.product_id
 WHERE DATE(s.sale_date) BETWEEN ? AND ?
 GROUP BY p.id
 ORDER BY total_qty DESC
 LIMIT ?
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$from,$to,$limit]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

// CSV export
if (isset($_GET['export']) && $_GET['export']==='csv') {
    header('Content-Type: text/csv'); header('Content-Disposition: attachment; filename=fast_moving_'.$from.'_'.$to.'.csv');
    $out = fopen('php://output','w');
    fputcsv($out, ['product_id','product_name','total_qty','revenue']);
    foreach ($rows as $r) fputcsv($out, [$r['id'],$r['name'],$r['total_qty'],$r['revenue']]);
    fclose($out); exit;
}
?>

<style>
/* Back button styling - consistent with other pages */
.back-btn {
    display: inline-block;
    padding: 8px 16px;
    background-color: #6c757d;
    color: white;
    text-decoration: none;
    border-radius: 4px;
    border: none;
    cursor: pointer;
    font-size: 14px;
    margin-bottom: 15px;
    transition: background-color 0.2s;
}
.back-btn:hover {
    background-color: #5a6268;
    color: white;
    text-decoration: none;
}
.back-btn i {
    margin-right: 5px;
}
</style>

<div class="col-md-10 ml-sm-auto px-4 py-4">

<!-- BACK BUTTON at the top -->
<div class="mb-3">
    <a href="daily_sales.php" class="back-btn">
        <i>←</i> Back to Reports
    </a>
</div>

<h3 class="text-success">Fast Moving Drugs</h3>

<form class="form-inline mb-3">
  <label class="mr-2">From</label><input type="date" name="from" value="<?= $from ?>" class="form-control mr-2">
  <label class="mr-2">To</label><input type="date" name="to" value="<?= $to ?>" class="form-control mr-2">
  <label class="mr-2">Limit</label><input type="number" name="limit" value="<?= $limit ?>" class="form-control mr-2" style="width:80px;">
  <button class="btn btn-primary mr-2">Filter</button>
  <a href="?from=<?= $from ?>&to=<?= $to ?>&limit=<?= $limit ?>&export=csv" 
     class="btn btn-outline-secondary mr-2">
     Export CSV
  </a>
</form>

<div class="table-responsive">
<table class="table table-sm table-bordered">
  <thead class="thead-dark"><tr><th>#</th><th>Product</th><th>Qty Sold</th><th>Revenue</th></tr></thead>
  <tbody>
  <?php 
  $i=1; 
  $total_qty = 0;
  $total_revenue = 0;
  foreach($rows as $r): 
    $total_qty += $r['total_qty'];
    $total_revenue += $r['revenue'];
  ?>
    <tr>
      <td><?= $i++ ?></td>
      <td><?= htmlspecialchars($r['name']) ?></td>
      <td><?= $r['total_qty'] ?></td>
      <td><?= number_format($r['revenue'],2) ?></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
  <tfoot>
    <tr class="table-secondary">
      <td colspan="2" class="text-right"><strong>Totals:</strong></td>
      <td><strong><?= $total_qty ?></strong></td>
      <td><strong><?= number_format($total_revenue,2) ?></strong></td>
    </tr>
  </tfoot>
</table>
</div>

<!-- BACK BUTTON at the bottom -->
<div class="mt-4">
    <a href="daily_sales.php" class="back-btn">
        <i>←</i> Back to Reports
    </a>
</div>

</div>

<?php require_once '../includes/footer.php'; ?>