<?php
session_start();
require_once '../assets/db_connect.php';
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
?>

<div class="col-md-10 ml-sm-auto px-4 py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="text-success mb-0">View Product Batches</h3>
        <a href="add_batch.php" class="btn btn-primary">+ Add New Batch</a>
    </div>

    <!-- Search Bar -->
    <div class="form-inline mb-3">
        <input type="text" id="search" class="form-control mr-2" placeholder="Search by Product, Batch, or Supplier" style="width: 300px;">
    </div>

    <!-- Table -->
    <div class="table-responsive" id="batches-table">
        <!-- AJAX results will be loaded here -->
        <table class="table table-bordered table-hover">
            <thead class="thead-light">
                <tr>
                    <th>#</th>
                    <th>Product</th>
                    <th>Batch No</th>
                    <th>Qty</th>
                    <th>Cost Price</th>
                    <th>Sell Price</th>
                    <th>Expiry Date</th>
                    <th>Supplier</th>
                    <th>Created At</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $stmt = $pdo->query("
                    SELECT b.*, p.name AS product_name, s.name AS supplier_name
                    FROM product_batches b
                    LEFT JOIN products p ON b.product_id = p.id
                    LEFT JOIN suppliers s ON b.supplier_id = s.id
                    ORDER BY b.id DESC
                ");
                while ($row = $stmt->fetch()):
                ?>
                <tr>
                    <td><?= $row['id'] ?></td>
                    <td><?= htmlspecialchars($row['product_name']) ?></td>
                    <td><?= htmlspecialchars($row['batch_no']) ?></td>
                    <td><?= $row['qty'] ?></td>
                    <td><?= number_format($row['cost_price'], 2) ?></td>
                    <td><?= number_format($row['sell_price'], 2) ?></td>
                    <td><?= $row['expiry_date'] ? date('d-M-Y', strtotime($row['expiry_date'])) : '-' ?></td>
                    <td><?= htmlspecialchars($row['supplier_name'] ?? '-') ?></td>
                    <td><?= date('d-M-Y H:i', strtotime($row['created_at'])) ?></td>
                    <td>
                        <a href="edit_batch.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="delete_batch.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this batch?')">Delete</a>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>

<script src="../libraries/jquery-3.5.1.min.js"></script>
<script>
$(document).ready(function() {
    $('#search').on('keyup', function() {
        var query = $(this).val();

        $.ajax({
            url: 'ajax_batches.php',
            method: 'GET',
            data: { search: query },
            success: function(data) {
                $('#batches-table').html(data);
            }
        });
    });
});
</script>

<?php require_once '../includes/footer.php'; ?>
