<style>
/* ===============================
   PURPLE + BLUE SIDEBAR THEME
================================ */

#sidebar {
    background: linear-gradient(180deg, #4c1d95, #1e3a8a);
    min-height: calc(100vh - 80px); /* Account for header height */
    padding-top: 20px;
    transition: all 0.3s ease-in-out;
    box-shadow: 4px 0 15px rgba(0,0,0,0.15);
    position: fixed;
    left: 0;
    top: 80px; /* Below header */
    width: 250px;
    z-index: 100;
    overflow-y: auto;
}

#sidebar h5 {
    color: rgba(255,255,255,0.85);
    font-weight: 700;
    letter-spacing: 1px;
    font-size: 13px;
}

/* Close button for desktop */
#sidebar .close-sidebar {
    position: absolute;
    top: 10px;
    right: 12px;
    background: none;
    border: none;
    color: rgba(255,255,255,0.6);
    font-size: 18px;
    cursor: pointer;
    z-index: 10;
    transition: all 0.3s ease;
}

#sidebar .close-sidebar:hover {
    color: #fff;
}

/* Links */
#sidebar .nav-link {
    color: #ffffff;
    font-weight: 500;
    padding: 12px 18px;
    border-radius: 8px;
    margin: 4px 10px;
    transition: all 0.25s ease;
    display: flex;
    align-items: center;
    white-space: nowrap;
}

/* Icons */
#sidebar .nav-link i {
    width: 22px;
    margin-right: 10px;
    color: #c7d2fe;
    transition: margin 0.3s ease;
}

/* Hover */
#sidebar .nav-link:hover {
    background: rgba(255,255,255,0.12);
    transform: translateX(4px);
}

/* Active link */
#sidebar .nav-link.active {
    background: #6d28d9 !important;
    box-shadow: 0 6px 15px rgba(109,40,217,0.35);
    font-weight: 600;
}

/* User display in sidebar */
.sidebar-user {
    padding: 15px 20px;
    border-bottom: 1px solid rgba(255,255,255,0.1);
    margin-bottom: 15px;
}

.sidebar-user .user-name {
    color: #fff;
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 3px;
}

.sidebar-user .shop-name {
    color: rgba(255,255,255,0.7);
    font-size: 12px;
}

/* ===============================
   MOBILE BEHAVIOR
================================ */

@media (max-width: 768px) {
    #sidebar {
        position: fixed;
        top: 80px;
        left: -260px;
        width: 240px;
        z-index: 1000;
        height: calc(100vh - 80px);
        overflow-y: auto;
    }

    #sidebar.show {
        left: 0;
    }
    
    /* Mobile overlay */
    #sidebarOverlay {
        display: none;
        position: fixed;
        top: 80px;
        left: 0;
        width: 100%;
        height: calc(100vh - 80px);
        background: rgba(0,0,0,0.5);
        z-index: 999;
    }
    
    #sidebarOverlay.show {
        display: block;
    }
    
    /* Shift main content on mobile when sidebar is open */
    body.sidebar-open .main-content-wrapper {
        margin-left: 240px;
    }
}

/* Desktop behavior */
@media (min-width: 769px) {
    /* When sidebar is collapsed on desktop */
    #sidebar.collapsed {
        width: 70px;
    }
    
    #sidebar.collapsed .nav-link {
        padding: 12px 8px;
        justify-content: center;
    }
    
    #sidebar.collapsed .nav-link i {
        margin-right: 0;
        font-size: 18px;
    }
    
    #sidebar.collapsed .nav-text,
    #sidebar.collapsed h5,
    #sidebar.collapsed .sidebar-user,
    #sidebar.collapsed .user-display {
        display: none;
    }
    
    #sidebar.collapsed .close-sidebar {
        right: auto;
        left: 50%;
        transform: translateX(-50%) rotate(180deg);
    }
    
    #sidebar:not(.collapsed) .close-sidebar {
        transform: rotate(0deg);
    }
    
    /* Adjust main content based on sidebar state */
    body:not(.sidebar-collapsed) .main-content-wrapper {
        margin-left: 250px;
        width: calc(100% - 250px);
    }
    
    body.sidebar-collapsed .main-content-wrapper {
        margin-left: 70px;
        width: calc(100% - 70px);
    }
}

/* Main content wrapper */
.main-content-wrapper {
    transition: all 0.3s ease;
    min-height: calc(100vh - 80px);
    padding: 20px;
}

/* Smooth transitions */
body, #sidebar, .main-content-wrapper {
    transition: all 0.3s ease-in-out;
}

/* Page content styling */
.page-content {
    background: #f5f7fb;
    min-height: calc(100vh - 80px);
    padding: 20px;
}
</style>

<?php
// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// Get user info from session
$user = $_SESSION['user'] ?? null;
?>

<!-- MOBILE OVERLAY (for outside click) -->
<div id="sidebarOverlay" class="d-md-none"></div>

<div class="sidebar" id="sidebar">
    <!-- Close button for desktop -->
    <button class="close-sidebar" id="closeSidebar" title="Toggle sidebar">
        <i class="fa fa-chevron-left"></i>
    </button>
    
    <!-- User info in sidebar -->
    <?php if ($user): ?>
    <div class="sidebar-user user-display">
        <div class="user-name">
            <i class="fa fa-user-circle mr-1"></i>
            <?= htmlspecialchars($user['fullname'] ?? 'User') ?>
        </div>
        <div class="shop-name">
            <i class="fa fa-store mr-1"></i>
            <?= htmlspecialchars($user['shop_name'] ?? 'Shop') ?>
        </div>
    </div>
    <?php endif; ?>
    
    <h5 class="text-center mb-4 nav-text">MAIN NAVIGATION</h5>

    <ul class="nav flex-column">

        <li class="nav-item">
            <a class="nav-link <?= basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : '' ?>"
               href="../dashboard.php">
                <i class="fa fa-home"></i> 
                <span class="nav-text">Dashboard</span>
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'products') !== false ? 'active' : '' ?>"
               href="../products/list_products.php">
                <i class="fa fa-cubes"></i> 
                <span class="nav-text">Products</span>
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'suppliers') !== false ? 'active' : '' ?>"
               href="../suppliers/supplier_list.php">
                <i class="fa fa-truck"></i> 
                <span class="nav-text">Suppliers</span>
            </a>
        </li>
         <?php if($_SESSION['user']['role']=='admin'){ ?>
       <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'suppliers') !== false ? 'active' : '' ?>"
               href="../../auth/register_user.php">
                <i class="fa fa-truck"></i> 
                <span class="nav-text">Add User</span>
            </a>
        </li>
         
         <?php }
		 else
		 {
			echo""; 
			 }
			 ?>

        <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'purchases') !== false ? 'active' : '' ?>"
               href="../purchases/list_purchases.php">
                <i class="fa fa-shopping-cart"></i> 
                <span class="nav-text">Purchases</span>
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'batches') !== false ? 'active' : '' ?>"
               href="../products/list_batches.php">
                <i class="fa fa-tags"></i> 
                <span class="nav-text">Batches</span>
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'sales') !== false ? 'active' : '' ?>"
               href="../sales/list_sales.php">
                <i class="fa fa-dollar"></i> 
                <span class="nav-text">Sales</span>
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link <?= strpos($_SERVER['PHP_SELF'], 'reports') !== false ? 'active' : '' ?>"
               href="../reports/daily_sales.php">
                <i class="fa fa-chart-line"></i> 
                <span class="nav-text">Reports</span>
            </a>
        </li>

        <li class="nav-item mt-3">
            <a class="nav-link" href="../../auth/logout.php">
                <i class="fa fa-sign-out-alt"></i> 
                <span class="nav-text">Logout</span>
            </a>
        </li>

    </ul>
</div>

<!-- SIDEBAR SCRIPT -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const sidebar = document.getElementById('sidebar');
    const closeSidebar = document.getElementById('closeSidebar');
    const sidebarOverlay = document.getElementById('sidebarOverlay');
    const navLinks = document.querySelectorAll('#sidebar .nav-link');
    const body = document.body;
    
    // Check localStorage for sidebar state
    const sidebarCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
    if (sidebarCollapsed && window.innerWidth >= 769) {
        sidebar.classList.add('collapsed');
        body.classList.add('sidebar-collapsed');
    } else if (window.innerWidth >= 769) {
        body.classList.remove('sidebar-collapsed');
    }
    
    // Close sidebar on desktop (collapse)
    closeSidebar.onclick = function() {
        if (window.innerWidth >= 769) {
            sidebar.classList.toggle('collapsed');
            body.classList.toggle('sidebar-collapsed');
            localStorage.setItem('sidebarCollapsed', sidebar.classList.contains('collapsed'));
        } else {
            // On mobile, close completely
            sidebar.classList.remove('show');
            sidebarOverlay.classList.remove('show');
            body.classList.remove('sidebar-open');
        }
    };
    
    // Close sidebar when clicking outside on mobile
    sidebarOverlay.onclick = function() {
        sidebar.classList.remove('show');
        sidebarOverlay.classList.remove('show');
        body.classList.remove('sidebar-open');
    };
    
    // Auto-close sidebar on mobile after clicking a link
    navLinks.forEach(link => {
        link.addEventListener('click', function() {
            if (window.innerWidth <= 768) {
                sidebar.classList.remove('show');
                sidebarOverlay.classList.remove('show');
                body.classList.remove('sidebar-open');
            }
        });
    });
    
    // Handle window resize
    function handleResize() {
        if (window.innerWidth >= 769) {
            // On desktop, ensure proper state
            sidebar.classList.remove('show');
            sidebarOverlay.classList.remove('show');
            body.classList.remove('sidebar-open');
            
            // Restore collapsed state from localStorage if on desktop
            const wasCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
            if (wasCollapsed) {
                sidebar.classList.add('collapsed');
                body.classList.add('sidebar-collapsed');
            } else {
                sidebar.classList.remove('collapsed');
                body.classList.remove('sidebar-collapsed');
            }
        } else {
            // On mobile, ensure collapsed state is removed
            sidebar.classList.remove('collapsed');
            body.classList.remove('sidebar-collapsed');
        }
    }
    
    window.addEventListener('resize', handleResize);
    
    // Initialize on load
    handleResize();
    
    // Close sidebar with Escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            sidebar.classList.remove('show');
            sidebarOverlay.classList.remove('show');
            body.classList.remove('sidebar-open');
        }
    });
    
    // Mobile toggle button functionality
    const mobileToggleBtn = document.querySelector('.navbar-toggler[data-target="#sidebar"]');
    if (mobileToggleBtn) {
        mobileToggleBtn.addEventListener('click', function(e) {
            e.stopPropagation();
            sidebar.classList.toggle('show');
            sidebarOverlay.classList.toggle('show');
            body.classList.toggle('sidebar-open');
        });
    }
    
    // Also handle the separate mobile toggle button if it exists
    const mobileMenuBtn = document.getElementById('sidebarToggle');
    if (mobileMenuBtn) {
        mobileMenuBtn.addEventListener('click', function(e) {
            e.stopPropagation();
            sidebar.classList.toggle('show');
            sidebarOverlay.classList.toggle('show');
            body.classList.toggle('sidebar-open');
        });
    }
});
</script>