/*!
 * Font Awesome Free 6.0.0-beta2 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License)
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};

  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {}

  var _ref = _WINDOW.navigator || {},
      _ref$userAgent = _ref.userAgent,
      userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e) {
      return false;
    }
  }();

  function bunker(fn) {
    try {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      fn.apply(void 0, args);
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);

      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }

      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  var w = WINDOW || {};
  if (!w[NAMESPACE_IDENTIFIER]) w[NAMESPACE_IDENTIFIER] = {};
  if (!w[NAMESPACE_IDENTIFIER].styles) w[NAMESPACE_IDENTIFIER].styles = {};
  if (!w[NAMESPACE_IDENTIFIER].hooks) w[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w[NAMESPACE_IDENTIFIER].shims) w[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w[NAMESPACE_IDENTIFIER];

  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;

      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }

      return acc;
    }, {});
  }

  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
        skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);

    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace.styles[prefix] = _objectSpread2(_objectSpread2({}, namespace.styles[prefix] || {}), normalized);
    }
    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll easy the upgrade process for our users by automatically defining
     * this as well.
     */


    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "address-book": [512, 512, [62138, "contact-book"], "f2b9", "M272 288h-64C163.8 288 128 323.8 128 368C128 376.8 135.2 384 144 384h192c8.836 0 16-7.164 16-16C352 323.8 316.2 288 272 288zM240 256c35.35 0 64-28.65 64-64s-28.65-64-64-64c-35.34 0-64 28.65-64 64S204.7 256 240 256zM496 320H480v96h16c8.836 0 16-7.164 16-16v-64C512 327.2 504.8 320 496 320zM496 64H480v96h16C504.8 160 512 152.8 512 144v-64C512 71.16 504.8 64 496 64zM496 192H480v96h16C504.8 288 512 280.8 512 272v-64C512 199.2 504.8 192 496 192zM384 0H96C60.65 0 32 28.65 32 64v384c0 35.35 28.65 64 64 64h288c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM400 448c0 8.836-7.164 16-16 16H96c-8.836 0-16-7.164-16-16V64c0-8.838 7.164-16 16-16h288c8.836 0 16 7.162 16 16V448z"],
    "address-card": [576, 512, [62140, "contact-card", "vcard"], "f2bb", "M208 256c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64s-64 28.65-64 64C144 227.3 172.7 256 208 256zM464 232h-96c-13.25 0-24 10.75-24 24s10.75 24 24 24h96c13.25 0 24-10.75 24-24S477.3 232 464 232zM240 288h-64C131.8 288 96 323.8 96 368C96 376.8 103.2 384 112 384h192c8.836 0 16-7.164 16-16C320 323.8 284.2 288 240 288zM464 152h-96c-13.25 0-24 10.75-24 24s10.75 24 24 24h96c13.25 0 24-10.75 24-24S477.3 152 464 152zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM528 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V416z"],
    "bell": [448, 512, [61602, 128276], "f0f3", "M256 32V49.88C328.5 61.39 384 124.2 384 200V233.4C384 278.8 399.5 322.9 427.8 358.4L442.7 377C448.5 384.2 449.6 394.1 445.6 402.4C441.6 410.7 433.2 416 424 416H24C14.77 416 6.365 410.7 2.369 402.4C-1.628 394.1-.504 384.2 5.26 377L20.17 358.4C48.54 322.9 64 278.8 64 233.4V200C64 124.2 119.5 61.39 192 49.88V32C192 14.33 206.3 0 224 0C241.7 0 256 14.33 256 32V32zM216 96C158.6 96 112 142.6 112 200V233.4C112 281.3 98.12 328 72.31 368H375.7C349.9 328 336 281.3 336 233.4V200C336 142.6 289.4 96 232 96H216zM288 448C288 464.1 281.3 481.3 269.3 493.3C257.3 505.3 240.1 512 224 512C207 512 190.7 505.3 178.7 493.3C166.7 481.3 160 464.1 160 448H288z"],
    "bell-slash": [640, 512, [61943, 128277], "f1f6", "M183.6 118.6C206.5 82.58 244.1 56.84 288 49.88V32C288 14.33 302.3 .0003 320 .0003C337.7 .0003 352 14.33 352 32V49.88C424.5 61.39 480 124.2 480 200V233.4C480 278.8 495.5 322.9 523.8 358.4L538.7 377C543.1 383.5 545.4 392.2 542.6 400L630.8 469.1C641.2 477.3 643.1 492.4 634.9 502.8C626.7 513.2 611.6 515.1 601.2 506.9L9.196 42.89C-1.236 34.71-3.065 19.63 5.112 9.196C13.29-1.236 28.37-3.065 38.81 5.112L183.6 118.6zM221.7 148.4L450.7 327.1C438.4 298.2 432 266.1 432 233.4V200C432 142.6 385.4 96 328 96H312C273.3 96 239.6 117.1 221.7 148.4V148.4zM160 233.4V222.1L206.7 258.9C202.7 297.7 189.5 335.2 168.3 368H345.2L406.2 416H120C110.8 416 102.4 410.7 98.37 402.4C94.37 394.1 95.5 384.2 101.3 377L116.2 358.4C144.5 322.9 160 278.8 160 233.4V233.4zM384 448C384 464.1 377.3 481.3 365.3 493.3C353.3 505.3 336.1 512 320 512C303 512 286.7 505.3 274.7 493.3C262.7 481.3 256 464.1 256 448H384z"],
    "bookmark": [384, 512, [61591, 128278], "f02e", "M336 0h-288C21.49 0 0 21.49 0 48v431.9c0 24.7 26.79 40.08 48.12 27.64L192 423.6l143.9 83.93C357.2 519.1 384 504.6 384 479.9V48C384 21.49 362.5 0 336 0zM336 452L192 368l-144 84V54C48 50.63 50.63 48 53.1 48h276C333.4 48 336 50.63 336 54V452z"],
    "building": [384, 512, [61687, 127970], "f1ad", "M88 104C88 95.16 95.16 88 104 88H152C160.8 88 168 95.16 168 104V152C168 160.8 160.8 168 152 168H104C95.16 168 88 160.8 88 152V104zM280 88C288.8 88 296 95.16 296 104V152C296 160.8 288.8 168 280 168H232C223.2 168 216 160.8 216 152V104C216 95.16 223.2 88 232 88H280zM88 232C88 223.2 95.16 216 104 216H152C160.8 216 168 223.2 168 232V280C168 288.8 160.8 296 152 296H104C95.16 296 88 288.8 88 280V232zM280 216C288.8 216 296 223.2 296 232V280C296 288.8 288.8 296 280 296H232C223.2 296 216 288.8 216 280V232C216 223.2 223.2 216 232 216H280zM0 64C0 28.65 28.65 0 64 0H320C355.3 0 384 28.65 384 64V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM48 64V448C48 456.8 55.16 464 64 464H144V400C144 373.5 165.5 352 192 352C218.5 352 240 373.5 240 400V464H320C328.8 464 336 456.8 336 448V64C336 55.16 328.8 48 320 48H64C55.16 48 48 55.16 48 64z"],
    "calendar": [448, 512, [128198, 128197], "f133", "M152 64H296V24C296 10.75 306.7 0 320 0C333.3 0 344 10.75 344 24V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H104V24C104 10.75 114.7 0 128 0C141.3 0 152 10.75 152 24V64zM48 448C48 456.8 55.16 464 64 464H384C392.8 464 400 456.8 400 448V192H48V448z"],
    "calendar-check": [448, 512, [], "f274", "M216.1 408.1C207.6 418.3 192.4 418.3 183 408.1L119 344.1C109.7 335.6 109.7 320.4 119 311C128.4 301.7 143.6 301.7 152.1 311L200 358.1L295 263C304.4 253.7 319.6 253.7 328.1 263C338.3 272.4 338.3 287.6 328.1 296.1L216.1 408.1zM128 0C141.3 0 152 10.75 152 24V64H296V24C296 10.75 306.7 0 320 0C333.3 0 344 10.75 344 24V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H104V24C104 10.75 114.7 0 128 0zM400 192H48V448C48 456.8 55.16 464 64 464H384C392.8 464 400 456.8 400 448V192z"],
    "calendar-days": [448, 512, ["calendar-alt"], "f073", "M152 64H296V24C296 10.75 306.7 0 320 0C333.3 0 344 10.75 344 24V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H104V24C104 10.75 114.7 0 128 0C141.3 0 152 10.75 152 24V64zM48 248H128V192H48V248zM48 296V360H128V296H48zM176 296V360H272V296H176zM320 296V360H400V296H320zM400 192H320V248H400V192zM400 408H320V464H384C392.8 464 400 456.8 400 448V408zM272 408H176V464H272V408zM128 408H48V448C48 456.8 55.16 464 64 464H128V408zM272 192H176V248H272V192z"],
    "calendar-minus": [448, 512, [], "f272", "M152 352C138.7 352 128 341.3 128 328C128 314.7 138.7 304 152 304H296C309.3 304 320 314.7 320 328C320 341.3 309.3 352 296 352H152zM128 0C141.3 0 152 10.75 152 24V64H296V24C296 10.75 306.7 0 320 0C333.3 0 344 10.75 344 24V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H104V24C104 10.75 114.7 0 128 0zM400 192H48V448C48 456.8 55.16 464 64 464H384C392.8 464 400 456.8 400 448V192z"],
    "calendar-plus": [448, 512, [], "f271", "M224 232C237.3 232 248 242.7 248 256V304H296C309.3 304 320 314.7 320 328C320 341.3 309.3 352 296 352H248V400C248 413.3 237.3 424 224 424C210.7 424 200 413.3 200 400V352H152C138.7 352 128 341.3 128 328C128 314.7 138.7 304 152 304H200V256C200 242.7 210.7 232 224 232zM152 64H296V24C296 10.75 306.7 0 320 0C333.3 0 344 10.75 344 24V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H104V24C104 10.75 114.7 0 128 0C141.3 0 152 10.75 152 24V64zM48 448C48 456.8 55.16 464 64 464H384C392.8 464 400 456.8 400 448V192H48V448z"],
    "calendar-xmark": [448, 512, ["calendar-times"], "f273", "M257.9 328L304.1 375C314.3 384.4 314.3 399.6 304.1 408.1C295.6 418.3 280.4 418.3 271 408.1L224 361.9L176.1 408.1C167.6 418.3 152.4 418.3 143 408.1C133.7 399.6 133.7 384.4 143 375L190.1 328L143 280.1C133.7 271.6 133.7 256.4 143 247C152.4 237.7 167.6 237.7 176.1 247L224 294.1L271 247C280.4 237.7 295.6 237.7 304.1 247C314.3 256.4 314.3 271.6 304.1 280.1L257.9 328zM128 0C141.3 0 152 10.75 152 24V64H296V24C296 10.75 306.7 0 320 0C333.3 0 344 10.75 344 24V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H104V24C104 10.75 114.7 0 128 0zM400 192H48V448C48 456.8 55.16 464 64 464H384C392.8 464 400 456.8 400 448V192z"],
    "chart-bar": [512, 512, ["bar-chart"], "f080", "M152 256h144C309.3 256 320 245.3 320 232S309.3 208 296 208h-144C138.8 208 128 218.8 128 232S138.8 256 152 256zM152 160h208C373.3 160 384 149.3 384 136S373.3 112 360 112h-208C138.8 112 128 122.8 128 136S138.8 160 152 160zM152 352h272c13.25 0 24-10.75 24-24S437.3 304 424 304h-272C138.8 304 128 314.8 128 328S138.8 352 152 352zM488 432H48V56C48 42.75 37.25 32 24 32S0 42.75 0 56V448c0 17.59 14.41 32 32 32h456c13.25 0 24-10.75 24-24S501.3 432 488 432z"],
    "chess-bishop": [320, 512, [9821], "f43a", "M296 464H23.1C10.75 464 0 474.7 0 487.1S10.75 512 23.1 512h272C309.3 512 320 501.3 320 488S309.3 464 296 464zM0 304c0 51.63 30.12 85.25 64 96v32h48v-67.13l-33.5-10.63C63.75 349.5 48 333.9 48 304c0-84.1 93.2-206.5 112.6-206.5c19.63 0 60.01 67.18 70.28 85.8l-66.13 66.13c-3.125 3.125-4.688 7.219-4.688 11.31S161.6 268.9 164.8 272L176 283.2c3.125 3.125 7.219 4.688 11.31 4.688s8.188-1.562 11.31-4.688L253 229C264.4 256.8 272 283.5 272 304c0 29.88-15.75 45.5-30.5 50.25L208 364.9V432H256v-32c33.88-10.75 64-44.38 64-96c0-73.38-67.75-197.2-120.6-241.5C213.4 59.12 224 47 224 32c0-17.62-14.38-32-32-32H128C110.4 0 96 14.38 96 32c0 15 10.62 27.12 24.62 30.5C67.75 106.8 0 230.6 0 304z"],
    "chess-king": [448, 512, [9818], "f43f", "M391.9 464H55.95c-13.25 0-23.1 10.75-23.1 23.1S42.7 512 55.95 512h335.1c13.25 0 23.1-10.75 23.1-23.1S405.2 464 391.9 464zM448 216c0-11.82-3.783-23.51-11.08-33.17c-10.3-14.39-27-22.88-44.73-22.88L247.9 160V104h31.1c13.2 0 24.06-10.8 24.06-24S293.1 56 279.9 56h-31.1V23.1C247.9 10.8 237.2 0 223.1 0S199.9 10.8 199.9 23.1V56H167.9c-13.2 0-23.97 10.8-23.97 24S154.7 104 167.9 104h31.1V160H55.95C24.72 160 0 185.3 0 215.9C0 221.6 .8893 227.4 2.704 233L68.45 432h50.5L48.33 218.4C48.09 217.6 47.98 216.9 47.98 216.1C47.98 212.3 50.93 208 55.95 208h335.9c6.076 0 8.115 5.494 8.115 8.113c0 .6341-.078 1.269-.2405 1.887L328.8 432h50.62l65.1-199.2C447.2 227.3 448 221.7 448 216z"],
    "chess-knight": [384, 512, [9822], "f441", "M44 320.6l14.5 6.5c-17.01 20.24-26.44 45.91-26.44 72.35C32.06 399.7 32.12 432 32.12 432h48v-32c0-24.75 14-47.5 36.13-58.63l38.13-23.37c13.25-6.625 21.75-20.25 21.75-35.13v-58.75l-15.37 9C155.6 235.8 151.9 240.4 150.5 245.9L143 271c-2.25 7.625-8 13.88-15.38 16.75L117.1 292C114 293.3 110.7 293.9 107.4 293.9c-3.626 0-7.263-.7514-10.66-2.254L63.5 276.9C54.12 272.6 48 263.2 48 252.9V140.5c0-5.125 2.125-10.12 5.75-13.88l7.375-7.375L49.5 96C48.5 94.12 48 92 48 89.88C48 84.38 52.38 80 57.88 80h105c86.75 0 156.1 70.38 156.1 157.1V432h48.06l-.0625-194.9C367.9 124 276 32 162.9 32H57.88C25.88 32 0 57.88 0 89.88c0 8.5 1.75 16.88 5.125 24.62C1.75 122.8 0 131.6 0 140.5v112.4C0 282.2 17.25 308.8 44 320.6zM80.12 164c0 11 8.875 20 20 20c11 0 20-9 20-20s-9-20-20-20C89 144 80.12 153 80.12 164zM360 464H23.1C10.75 464 0 474.7 0 487.1S10.75 512 23.1 512H360C373.3 512 384 501.3 384 488S373.3 464 360 464z"],
    "chess-pawn": [320, 512, [9823], "f443", "M296 463.1H23.1c-13.25 0-23.1 10.75-23.1 24s10.75 24 23.1 24h272c13.25 0 23.1-10.75 23.1-23.1S309.3 463.1 296 463.1zM55.1 287.1L80 287.1v29.5c0 40.25-3.5 81.25-23.38 114.5h53.5C125.1 394.1 128 354.6 128 317.5v-29.5h64v29.5c0 37.13 2.875 77.5 17.88 114.5h53.5C243.5 398.7 240 357.7 240 317.5V287.1l24-.0001C277.3 287.1 288 277.3 288 263.1c0-13.25-10.75-24-23.1-24H241c23.75-21.88 38.1-53.12 38.1-87.1c0-9.393-1.106-19.05-3.451-28.86C272.3 105.4 244.9 32 159.1 32C93.75 32 40 85.75 40 151.1c0 34.88 15.12 66.12 39 88H55.1C42.75 239.1 32 250.7 32 263.1C32 277.3 42.75 287.1 55.1 287.1zM160 79.1c39.75 0 72 32.25 72 72S199.8 223.1 160 223.1S88 191.7 88 151.1S120.2 79.1 160 79.1z"],
    "chess-queen": [512, 512, [9819], "f445", "M256 112c30.88 0 56-25.12 56-56S286.9 0 256 0S199.1 25.12 199.1 56S225.1 112 256 112zM511.1 197.4c0-5.178-2.509-10.2-7.096-13.26L476.4 168.2c-2.5-1.75-5.497-2.62-8.497-2.62c-5.501 .125-10.63 2.87-13.75 7.245c-9.001 12-23.16 19.13-38.16 19.13c-3.125 0-6.089-.2528-9.089-.8778c-23.13-4.25-38.88-26.25-38.88-49.75C367.1 134 361.1 128 354.6 128h-38.75c-6.001 0-11.63 4-12.88 9.875C298.2 160.1 278.7 176 255.1 176c-22.75 0-42.25-15.88-47-38.12C207.7 132 202.2 128 196.1 128h-38.75C149.1 128 143.1 134 143.1 141.4c0 18.49-13.66 50.62-47.95 50.62c-15.13 0-29.3-7.118-38.3-19.24C54.6 168.4 49.66 165.7 44.15 165.6c-3 0-5.931 .8951-8.432 2.645l-28.63 16C2.509 187.2 0 192.3 0 197.4c0 2.438 .5583 4.901 1.72 7.185L109.9 432h53.13L69.85 236.4C78.35 238.8 87.11 240 95.98 240c2.432 0 56.83 1.503 84.76-52.5C198.1 210.5 226.6 224 255.9 224c29.38 0 57.01-13.38 75.26-36.25C336.1 197.6 360.6 240 416 240c8.751 0 17.5-1.125 26-3.5L349 432h53.13l108.1-227.4C511.4 202.3 511.1 199.8 511.1 197.4zM424 464H87.98c-13.26 0-24 10.75-24 23.1S74.72 512 87.98 512h336c13.26 0 24-10.75 24-23.1S437.3 464 424 464z"],
    "chess-rook": [384, 512, [9820], "f447", "M360 464H23.1C10.75 464 0 474.7 0 487.1S10.75 512 23.1 512H360C373.3 512 384 501.3 384 488S373.3 464 360 464zM345.1 32h-308C17 32 0 49 0 70v139.4C0 218.8 4 227.5 11 233.6L48 265.8c0 8.885 .0504 17.64 .0504 26.46c0 39.32-1.001 79.96-11.93 139.8h49C94.95 374.3 96.11 333.3 96.11 285.5C96.11 270.7 96 255.1 96 238.2L48 196.5V80h64V128H160V80h64V128h48V80h64v116.5L288 238.2c0 16.77-.1124 32.25-.1124 47.1c0 47.79 1.164 89.15 10.99 146.7h49c-10.92-59.83-11.93-100.6-11.93-139.9C335.9 283.3 336 274.6 336 265.8l37-32.13C380 227.5 384 218.8 384 209.4V70C384 49 367 32 345.1 32zM192 224C174.4 224 160 238.4 160 256v64h64V256C224 238.4 209.6 224 192 224z"],
    "circle": [512, 512, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9898, 9899, 11044, 61708, 61915, 9679], "f111", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-check": [512, 512, [61533, "check-circle"], "f058", "M335 175L224 286.1L176.1 239c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l64 64C211.7 341.7 217.8 344 224 344s12.28-2.344 16.97-7.031l128-128c9.375-9.375 9.375-24.56 0-33.94S344.4 165.7 335 175zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-dot": [512, 512, [128280, "dot-circle"], "f192", "M256 160C203 160 160 203 160 256c0 52.95 43.05 96 96 96s96-43.05 96-96C352 203 308.1 160 256 160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-down": [512, 512, [61466, "arrow-alt-circle-down"], "f358", "M344 240h-56L287.1 152c0-13.25-10.75-24-24-24h-16C234.7 128 223.1 138.8 223.1 152L224 240h-56c-9.531 0-18.16 5.656-22 14.38C142.2 263.1 143.9 273.3 150.4 280.3l88.75 96C243.7 381.2 250.1 384 256.8 384c7.781-.3125 13.25-2.875 17.75-7.844l87.25-96c6.406-7.031 8.031-17.19 4.188-25.88S353.5 240 344 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-left": [512, 512, [61840, "arrow-alt-circle-left"], "f359", "M360 224L272 224v-56c0-9.531-5.656-18.16-14.38-22C248.9 142.2 238.7 143.9 231.7 150.4l-96 88.75C130.8 243.7 128 250.1 128 256.8c.3125 7.781 2.875 13.25 7.844 17.75l96 87.25c7.031 6.406 17.19 8.031 25.88 4.188s14.28-12.44 14.28-21.94l-.002-56L360 288C373.3 288 384 277.3 384 264v-16C384 234.8 373.3 224 360 224zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-pause": [512, 512, [62092, "pause-circle"], "f28b", "M200 160C186.8 160 176 170.8 176 184v144C176 341.3 186.8 352 200 352S224 341.3 224 328v-144C224 170.8 213.3 160 200 160zM312 160C298.8 160 288 170.8 288 184v144c0 13.25 10.75 24 24 24s24-10.75 24-24v-144C336 170.8 325.3 160 312 160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-play": [512, 512, [61469, "play-circle"], "f144", "M228.5 147.5C224.7 145.2 220.3 144 216 144C202.2 144 192 155.3 192 168v176c0 12.8 10.31 24 24 24c4.344 0 8.68-1.18 12.52-3.523l144-88C379.6 272.1 384 264.4 384 256c0-8.359-4.352-16.12-11.48-20.48L228.5 147.5zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-question": [512, 512, [62108, "question-circle"], "f059", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM256 336c-18 0-32 14-32 32s13.1 32 32 32c17.1 0 32-14 32-32S273.1 336 256 336zM289.1 128h-51.1C199 128 168 159 168 198c0 13 11 24 24 24s24-11 24-24C216 186 225.1 176 237.1 176h51.1C301.1 176 312 186 312 198c0 8-4 14.1-11 18.1L244 251C236 256 232 264 232 272V288c0 13 11 24 24 24S280 301 280 288V286l45.1-28c21-13 34-36 34-60C360 159 329 128 289.1 128z"],
    "circle-right": [512, 512, [61838, "arrow-alt-circle-right"], "f35a", "M280.2 150.2C273.1 143.8 262.1 142.2 254.3 146.1S239.1 158.5 239.1 167.1l.002 56L152 224C138.8 224 128 234.8 128 248v16C128 277.3 138.8 288 152 288L240 287.1v56c0 9.531 5.656 18.16 14.38 22c8.75 3.812 18.91 2.094 25.91-4.375l96-88.75C381.2 268.3 384 261.9 384 255.2c-.3125-7.781-2.875-13.25-7.844-17.75L280.2 150.2zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-stop": [512, 512, [62094, "stop-circle"], "f28d", "M328 160h-144C170.8 160 160 170.8 160 184v144C160 341.2 170.8 352 184 352h144c13.2 0 24-10.8 24-24v-144C352 170.8 341.2 160 328 160zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-up": [512, 512, [61467, "arrow-alt-circle-up"], "f35b", "M272.9 135.7C268.3 130.8 261.9 128 255.2 128C247.5 128.3 241.1 130.9 237.5 135.8l-87.25 96C143.8 238.9 142.2 249 146.1 257.7C149.9 266.4 158.5 272 167.1 272h56L224 360c0 13.25 10.75 24 24 24h16c13.25 0 23.1-10.75 23.1-24L287.1 272h56c9.531 0 18.16-5.656 22-14.38c3.811-8.75 2.092-18.91-4.377-25.91L272.9 135.7zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "circle-user": [512, 512, [62142, "user-circle"], "f2bd", "M256 112c-48.6 0-88 39.4-88 88C168 248.6 207.4 288 256 288s88-39.4 88-88C344 151.4 304.6 112 256 112zM256 240c-22.06 0-40-17.95-40-40C216 177.9 233.9 160 256 160s40 17.94 40 40C296 222.1 278.1 240 256 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-46.73 0-89.76-15.68-124.5-41.79C148.8 389 182.4 368 220.2 368h71.69c37.75 0 71.31 21.01 88.68 54.21C345.8 448.3 302.7 464 256 464zM416.2 388.5C389.2 346.3 343.2 320 291.8 320H220.2c-51.36 0-97.35 26.25-124.4 68.48C65.96 352.5 48 306.3 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208C464 306.3 446 352.5 416.2 388.5z"],
    "circle-xmark": [512, 512, [61532, "times-circle", "xmark-circle"], "f057", "M336.1 175c-9.375-9.375-24.56-9.375-33.94 0L256 222.1L208.1 175c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l47.03 47.03L175 303c-9.375 9.375-9.375 24.56 0 33.94c9.373 9.373 24.56 9.381 33.94 0L256 289.9l47.03 47.03c9.373 9.373 24.56 9.381 33.94 0c9.375-9.375 9.375-24.56 0-33.94l-47.03-47.03l47.03-47.03C346.3 199.6 346.3 184.4 336.1 175zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256S512 397.4 512 256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "clipboard": [384, 512, [128203], "f328", "M320 64h-49.61C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64H64C28.65 64 0 92.66 0 128v320c0 35.34 28.65 64 64 64h256c35.35 0 64-28.66 64-64V128C384 92.66 355.3 64 320 64zM192 48c13.23 0 24 10.77 24 24S205.2 96 192 96S168 85.23 168 72S178.8 48 192 48zM336 448c0 8.82-7.178 16-16 16H64c-8.822 0-16-7.18-16-16V128c0-8.82 7.178-16 16-16h18.26C80.93 117.1 80 122.4 80 128v16C80 152.8 87.16 160 96 160h192c8.836 0 16-7.164 16-16V128c0-5.559-.9316-10.86-2.264-16H320c8.822 0 16 7.18 16 16V448z"],
    "clock": [512, 512, [128339, "clock-four"], "f017", "M232 120C232 106.7 242.7 96 256 96C269.3 96 280 106.7 280 120V243.2L365.3 300C376.3 307.4 379.3 322.3 371.1 333.3C364.6 344.3 349.7 347.3 338.7 339.1L242.7 275.1C236 271.5 232 264 232 255.1L232 120zM256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM48 256C48 370.9 141.1 464 256 464C370.9 464 464 370.9 464 256C464 141.1 370.9 48 256 48C141.1 48 48 141.1 48 256z"],
    "clone": [512, 512, [], "f24d", "M448 0H224C188.7 0 160 28.65 160 64v224c0 35.35 28.65 64 64 64h224c35.35 0 64-28.65 64-64V64C512 28.65 483.3 0 448 0zM464 288c0 8.822-7.178 16-16 16H224C215.2 304 208 296.8 208 288V64c0-8.822 7.178-16 16-16h224c8.822 0 16 7.178 16 16V288zM304 448c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V224c0-8.822 7.178-16 16-16h64V160H64C28.65 160 0 188.7 0 224v224c0 35.35 28.65 64 64 64h224c35.35 0 64-28.65 64-64v-64h-48V448z"],
    "closed-captioning": [576, 512, [], "f20a", "M512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM528 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V416zM236.5 222.1c9.375 9.375 24.56 9.375 33.94 0c9.375-9.375 9.375-24.56 0-33.94c-37.44-37.44-98.31-37.44-135.7 0C116.5 206.2 106.5 230.4 106.5 256s9.1 49.75 28.12 67.88c18.72 18.72 43.28 28.08 67.87 28.08s49.16-9.359 67.87-28.08c9.375-9.375 9.375-24.56 0-33.94c-9.375-9.375-24.56-9.375-33.94 0c-18.69 18.72-49.19 18.72-67.87 0C159.5 280.9 154.5 268.8 154.5 256s5-24.88 14.06-33.94C187.3 203.3 217.8 203.3 236.5 222.1zM428.5 222.1c9.375 9.375 24.56 9.375 33.94 0c9.375-9.375 9.375-24.56 0-33.94c-37.44-37.44-98.31-37.44-135.7 0C308.5 206.2 298.5 230.4 298.5 256s9.1 49.75 28.12 67.88c18.72 18.72 43.28 28.08 67.87 28.08s49.16-9.359 67.87-28.08c9.375-9.375 9.375-24.56 0-33.94c-9.375-9.375-24.56-9.375-33.94 0c-18.69 18.72-49.19 18.72-67.87 0C351.5 280.9 346.5 268.8 346.5 256s5-24.88 14.06-33.94C379.3 203.3 409.8 203.3 428.5 222.1z"],
    "comment": [512, 512, [61669, 128489], "f075", "M256 32C114.6 32 .0272 125.1 .0272 240c0 47.63 19.91 91.25 52.91 126.2c-14.88 39.5-45.87 72.88-46.37 73.25c-6.625 7-8.375 17.25-4.625 26C5.818 474.2 14.38 480 24 480c61.5 0 109.1-25.75 139.1-46.25C191.1 442.8 223.3 448 256 448c141.4 0 255.1-93.13 255.1-208S397.4 32 256 32zM256.1 400c-26.75 0-53.12-4.125-78.38-12.12l-22.75-7.125l-19.5 13.75c-14.25 10.12-33.88 21.38-57.5 29c7.375-12.12 14.37-25.75 19.88-40.25l10.62-28l-20.62-21.87C69.82 314.1 48.07 282.2 48.07 240c0-88.25 93.25-160 208-160s208 71.75 208 160S370.8 400 256.1 400z"],
    "comment-dots": [512, 512, [62075, 128172, "commenting"], "f4ad", "M144 208C126.3 208 112 222.2 112 239.1C112 257.7 126.3 272 144 272s31.1-14.25 31.1-32S161.8 208 144 208zM256 207.1c-17.75 0-31.1 14.25-31.1 32s14.25 31.1 31.1 31.1s31.1-14.25 31.1-31.1S273.8 207.1 256 207.1zM368 208c-17.75 0-31.1 14.25-31.1 32s14.25 32 31.1 32c17.75 0 31.99-14.25 31.99-32C400 222.2 385.8 208 368 208zM256 31.1c-141.4 0-255.1 93.12-255.1 208c0 47.62 19.91 91.25 52.91 126.3c-14.87 39.5-45.87 72.88-46.37 73.25c-6.624 7-8.373 17.25-4.624 26C5.818 474.2 14.38 480 24 480c61.49 0 109.1-25.75 139.1-46.25c28.87 9 60.16 14.25 92.9 14.25c141.4 0 255.1-93.13 255.1-207.1S397.4 31.1 256 31.1zM256 400c-26.75 0-53.12-4.125-78.36-12.12l-22.75-7.125L135.4 394.5c-14.25 10.12-33.87 21.38-57.49 29c7.374-12.12 14.37-25.75 19.87-40.25l10.62-28l-20.62-21.87C69.81 314.1 48.06 282.2 48.06 240c0-88.25 93.24-160 207.1-160s207.1 71.75 207.1 160S370.8 400 256 400z"],
    "comments": [640, 512, [61670, 128490], "f086", "M208 0C322.9 0 416 78.8 416 176C416 273.2 322.9 352 208 352C189.3 352 171.2 349.7 153.9 345.8C123.3 364.8 79.13 384 24.95 384C14.97 384 5.93 378.1 2.018 368.9C-1.896 359.7-.0074 349.1 6.739 341.9C7.26 341.5 29.38 317.4 45.73 285.9C17.18 255.8 0 217.6 0 176C0 78.8 93.13 0 208 0zM164.6 298.1C179.2 302.3 193.8 304 208 304C296.2 304 368 246.6 368 176C368 105.4 296.2 48 208 48C119.8 48 48 105.4 48 176C48 211.2 65.71 237.2 80.57 252.9L104.1 277.8L88.31 308.1C84.74 314.1 80.73 321.9 76.55 328.5C94.26 323.4 111.7 315.5 128.7 304.1L145.4 294.6L164.6 298.1zM441.6 128.2C552 132.4 640 209.5 640 304C640 345.6 622.8 383.8 594.3 413.9C610.6 445.4 632.7 469.5 633.3 469.9C640 477.1 641.9 487.7 637.1 496.9C634.1 506.1 625 512 615 512C560.9 512 516.7 492.8 486.1 473.8C468.8 477.7 450.7 480 432 480C350 480 279.1 439.8 245.2 381.5C262.5 379.2 279.1 375.3 294.9 369.9C322.9 407.1 373.9 432 432 432C446.2 432 460.8 430.3 475.4 426.1L494.6 422.6L511.3 432.1C528.3 443.5 545.7 451.4 563.5 456.5C559.3 449.9 555.3 442.1 551.7 436.1L535.9 405.8L559.4 380.9C574.3 365.3 592 339.2 592 304C592 237.7 528.7 183.1 447.1 176.6L448 176C448 159.5 445.8 143.5 441.6 128.2H441.6z"],
    "compass": [576, 512, [129517], "f14e", "M358.1 143.5L243.6 195.8c-5.957 2.723-13.06 9.824-15.78 15.78l-52.33 114.5c-12.32 26.95 15.45 54.72 42.4 42.41l114.5-52.32c5.939-2.715 13.03-9.817 15.75-15.76l52.34-114.5C412.8 158.1 385 131.2 358.1 143.5zM310.6 278.6c-12.5 12.5-32.75 12.5-45.25 0c-12.5-12.5-12.5-32.75 0-45.25c12.5-12.5 32.75-12.5 45.25 0C323.1 245.9 323.1 266.1 310.6 278.6zM288 0C146.6 0 32 114.6 32 256s114.6 256 256 256s256-114.6 256-256S429.4 0 288 0zM288 464c-114.7 0-208-93.31-208-208S173.3 48 288 48s208 93.31 208 208S402.7 464 288 464z"],
    "copy": [512, 512, [], "f0c5", "M502.6 70.63l-61.25-61.25C435.4 3.371 427.2 0 418.7 0H255.1c-35.35 0-64 28.66-64 64l.0195 256C192 355.4 220.7 384 256 384h192c35.2 0 64-28.8 64-64V93.25C512 84.77 508.6 76.63 502.6 70.63zM464 320c0 8.836-7.164 16-16 16H255.1c-8.838 0-16-7.164-16-16L239.1 64.13c0-8.836 7.164-16 16-16h128L384 96c0 17.67 14.33 32 32 32h47.1V320zM272 448c0 8.836-7.164 16-16 16H63.1c-8.838 0-16-7.164-16-16L47.98 192.1c0-8.836 7.164-16 16-16H160V128H63.99c-35.35 0-64 28.65-64 64l.0098 256C.002 483.3 28.66 512 64 512h192c35.2 0 64-28.8 64-64v-32h-47.1L272 448z"],
    "copyright": [512, 512, [169], "f1f9", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM255.1 176C255.1 176 255.1 176 255.1 176c21.06 0 40.92 8.312 55.83 23.38c9.375 9.344 24.53 9.5 33.97 .1562c9.406-9.344 9.469-24.53 .1562-33.97c-24-24.22-55.95-37.56-89.95-37.56c0 0 .0313 0 0 0c-33.97 0-65.95 13.34-89.95 37.56c-49.44 49.88-49.44 131 0 180.9c24 24.22 55.98 37.56 89.95 37.56c.0313 0 0 0 0 0c34 0 65.95-13.34 89.95-37.56c9.312-9.438 9.25-24.62-.1562-33.97c-9.438-9.312-24.59-9.219-33.97 .1562c-14.91 15.06-34.77 23.38-55.83 23.38c0 0 .0313 0 0 0c-21.09 0-40.95-8.312-55.89-23.38c-30.94-31.22-30.94-82.03 0-113.3C214.2 184.3 234 176 255.1 176z"],
    "credit-card": [576, 512, [62083, 128179, "credit-card-alt"], "f09d", "M512 32h-448c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM48.13 96c0-8.838 7.164-16 16-16h447.8c8.836 0 16 7.162 16 16v32H48.13V96zM527.9 416c0 8.836-7.164 16-16 16H64.13c-8.836 0-16-7.164-16-16L48 224h480L527.9 416zM120 384h48c13.25 0 23.1-10.75 23.1-24S181.3 336 168 336h-48C106.8 336 96 346.8 96 360S106.8 384 120 384zM248 384h112c13.25 0 24-10.75 24-24c0-13.26-10.75-24-24-24h-112C234.7 336 224 346.7 224 360C224 373.3 234.7 384 248 384z"],
    "envelope": [512, 512, [128386, 61443, 9993], "f0e0", "M448 64H64C28.65 64 0 92.65 0 128v256c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V128C512 92.65 483.3 64 448 64zM64 112h384c8.822 0 16 7.178 16 16v22.16l-166.8 138.1c-23.19 19.28-59.34 19.27-82.47 .0156L48 150.2V128C48 119.2 55.18 112 64 112zM448 400H64c-8.822 0-16-7.178-16-16V212.7l136.1 113.4C204.3 342.8 229.8 352 256 352s51.75-9.188 71.97-25.98L464 212.7V384C464 392.8 456.8 400 448 400z"],
    "envelope-open": [512, 512, [62135], "f2b6", "M493.6 163c-24.88-19.62-45.5-35.37-164.3-121.6C312.7 29.21 279.7 0 256.4 0H255.6C232.3 0 199.3 29.21 182.6 41.38C63.88 127.6 43.25 143.4 18.38 163C6.75 172 0 186 0 200.8v247.2C0 483.3 28.65 512 64 512h384c35.35 0 64-28.67 64-64.01V200.8C512 186 505.3 172 493.6 163zM464 448c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V276.7l136.1 113.4C204.3 406.8 229.8 416 256 416s51.75-9.211 71.97-26.01L464 276.7V448zM464 214.2l-166.8 138.1c-23.19 19.28-59.34 19.27-82.47 .0156L48 214.2l.1055-13.48c23.24-18.33 42.25-32.97 162.9-120.6c3.082-2.254 6.674-5.027 10.63-8.094C229.4 65.99 246.7 52.59 256 48.62c9.312 3.973 26.62 17.37 34.41 23.41c3.959 3.066 7.553 5.84 10.76 8.186C421.6 167.7 440.7 182.4 464 200.8V214.2z"],
    "eye": [576, 512, [128065], "f06e", "M572.5 238.1C518.3 115.5 410.9 32 288 32S57.69 115.6 3.469 238.1C1.563 243.4 0 251 0 256c0 4.977 1.562 12.6 3.469 17.03C57.72 396.5 165.1 480 288 480s230.3-83.58 284.5-206.1C574.4 268.6 576 260.1 576 256C576 251 574.4 243.4 572.5 238.1zM288 432c-99.48 0-191.2-67.5-239.6-175.1C97.01 147.4 188.6 80 288 80c99.48 0 191.2 67.5 239.6 175.1C478.1 364.6 387.4 432 288 432zM288 128C217.3 128 160 185.3 160 256s57.33 128 128 128c70.64 0 128-57.32 128-127.9C416 185.4 358.7 128 288 128zM288 336c-44.11 0-80-35.89-80-80c0-.748 .1992-1.441 .2207-2.184C213.3 255.1 218.5 256 224 256c35.35 0 64-28.65 64-64c0-5.48-.875-10.72-2.184-15.78C286.6 176.2 287.3 176 288 176c44.11 0 80 35.89 80 80.05C368 300.1 332.1 336 288 336z"],
    "eye-slash": [640, 512, [], "f070", "M630.8 469.1l-103.5-81.11c31.35-31.94 57.79-70.78 77.21-114.1c1.906-4.43 3.469-12.07 3.469-17.03c0-4.977-1.562-12.6-3.469-17.03c-54.25-123.4-161.6-206.1-284.5-206.1c-62.67 0-121.2 21.95-170.8 59.62L38.81 5.116C34.41 1.679 29.19 0 24.03 0C16.91 0 9.839 3.158 5.121 9.189c-8.188 10.44-6.37 25.53 4.068 33.7l591.1 463.1c10.5 8.203 25.57 6.333 33.69-4.073C643.1 492.4 641.2 477.3 630.8 469.1zM394.4 283.8l-81.65-63.1C316.1 211.3 319.1 202.2 319.1 192c0-5.48-.8744-10.73-2.183-15.78C318.6 176.2 319.3 176 320 176c44.11 0 80 35.89 80 80.05C400 265.9 397.7 275.1 394.4 283.8zM433.2 314.2C442.4 296.8 448 277.2 448 256.1C448 185.4 390.7 128 320 128C287.8 128 258.7 140.2 236.3 159.9L188.3 122.3C228 95.03 273.1 80 320 80c99.48 0 191.2 67.5 239.6 175.1c-18.06 40.38-42.41 74.43-70.61 101.9L433.2 314.2zM320 384c13.42 0 26.16-2.643 38.31-6.477L302.8 334C279.1 328.8 259.5 312.9 248.8 291.7L192.8 247.8C192.6 250.6 192 253.2 192 256C192 326.7 249.3 384 320 384zM320 432c-99.48 0-191.2-67.5-239.6-175.1c10.83-24.22 24.09-46.03 38.81-65.86L81.28 160.4c-17.77 23.74-33.27 50.04-45.81 78.59C33.56 243.4 31.1 251 31.1 256c0 4.977 1.562 12.6 3.469 17.03c54.25 123.4 161.6 206.1 284.5 206.1c45.46 0 88.77-11.49 128.1-32.14l-42.87-33.59C378 425.4 349.5 432 320 432z"],
    "face-angry": [512, 512, [128544, "angry"], "f556", "M256 312c-33.54 0-65.15 14.75-86.82 40.63c-8.477 10.12-7.023 25.25 3.148 33.75s25.31 7.25 33.79-3c24.82-29.62 74.96-29.62 99.78 0c8.113 9.75 23.25 11.88 33.79 3c10.17-8.5 11.5-23.62 3.148-33.75C321.1 326.8 289.5 312 256 312zM208 240c10.29 0 19.86-6.75 23.01-17.12C234.8 210.3 227.5 196.8 214.9 193l-80.04-24c-12.84-3.875-26.16 3.375-29.91 16.12C101.2 197.8 108.4 211.3 121.1 215l28.21 8.5C146.2 228.4 143.1 233.8 143.1 240c0 17.62 14.38 32 32.06 32C193.8 272 208 257.8 208 240zM407 185.1c-3.754-12.75-17.07-19.88-29.91-16.12l-80.04 24c-12.59 3.75-19.86 17.25-16.11 29.88C284.1 233.3 293.8 240 304 240c0 17.75 14.2 32 31.1 32c17.68 0 32.06-14.25 32.06-32c0-6.25-2.271-11.75-5.419-16.62l28.21-8.5C403.6 211.3 410.8 197.8 407 185.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-dizzy": [512, 512, ["dizzy"], "f567", "M256 272c-35.36 0-64.06 28.75-64.06 64S220.6 400 256 400s64.06-28.75 64.06-64S291.4 272 256 272zM382.2 145.9c-7.75-7.75-20.46-7.75-28.34 0l-17.8 17.88l-17.8-17.88c-7.871-7.75-20.59-7.75-28.34 0c-7.75 7.875-7.75 20.5 0 28.38l17.92 17.88L289.9 210c-7.75 7.75-7.75 20.5 0 28.25c7.75 7.875 20.46 7.875 28.34 0l17.8-17.75l17.8 17.75c7.75 7.875 20.46 7.875 28.21 0c7.871-7.75 7.871-20.5 0-28.25L364.3 192l17.92-17.88C389.9 166.3 389.9 153.8 382.2 145.9zM222.2 238.1c7.75-7.875 7.75-20.5 0-28.38L204.3 192l17.92-17.88c7.75-7.875 7.75-20.5 0-28.38c-7.871-7.75-20.46-7.75-28.34 0l-17.92 18L158.2 145.9c-7.75-7.75-20.46-7.75-28.21 0c-7.871 7.875-7.871 20.5 0 28.38l17.8 17.88L129.9 210c-7.871 7.75-7.871 20.5 0 28.25c7.75 7.875 20.46 7.875 28.21 0L175.1 220.5l17.8 17.75C201.8 246 214.3 246 222.2 238.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-flushed": [512, 512, [128563, "flushed"], "f579", "M352 152c-39.79 0-72.05 32.17-72.05 72c0 39.82 32.26 72 72.05 72c39.79 0 71.93-32.18 71.93-72C423.1 184.2 391.8 152 352 152zM352.1 264C329.1 264 312 246.1 312 224c0-22.06 17.97-40 40.05-40C374.1 184 392 201.9 392 224C392 246.1 374.1 264 352.1 264zM159.1 200c-13.33 0-23.98 10.75-23.98 24s10.65 24 23.98 24S183.1 237.3 183.1 224S173.3 200 159.1 200zM231.1 224c0-39.83-32.23-72-72.02-72c-39.79 0-71.97 32.17-71.97 72c0 39.82 32.18 72 71.97 72C199.8 296 231.1 263.8 231.1 224zM160.1 264C137.1 264 120 246.1 120 224c0-22.06 17.97-40 40.05-40C182.1 184 200 201.9 200 224C200 246.1 182.1 264 160.1 264zM312 335.1H199.1c-13.2 0-23.98 10.75-23.98 24s10.78 24 23.98 24h112.1c13.2 0 23.98-10.75 23.98-24S325.2 335.1 312 335.1zM352 200c-13.33 0-23.98 10.75-23.98 24s10.65 24 23.98 24S375.1 237.3 375.1 224S365.3 200 352 200zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-frown": [512, 512, [9785, "frown"], "f119", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM175.1 240c17.8 0 32.09-14.25 32.09-32s-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32S158.3 240 175.1 240zM336 240c17.68 0 31.97-14.25 31.97-32s-14.29-32-31.97-32c-17.8 0-32.09 14.25-32.09 32S318.2 240 336 240zM256 272c-86.31 0-121.2 65.16-127.6 99.63C126 384.6 134.5 396.1 147.5 399.5c12.81 2.438 25.5-6 28.09-18.91C176.8 374.4 189.7 320 256 320s79.19 54.38 80.41 60.38C338.5 391.9 348.6 400 359.1 400c1.469 0 2.938-.125 4.406-.4062c13.03-2.406 21.62-14.94 19.22-27.97C377.2 337.2 342.3 272 256 272z"],
    "face-frown-open": [512, 512, [128550, "frown-open"], "f57a", "M256 288c-35.6 0-88.76 21.25-95.79 61.25c-2.059 11.75 8.961 21.5 20.46 18C211.9 357.8 240.1 352 256 352s44.08 5.75 75.32 15.25c11.38 3.5 22.52-6.25 20.46-18C344.8 309.3 291.6 288 256 288zM208 208c0-17.75-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32s14.29 32 31.97 32C193.8 240 208 225.8 208 208zM336 176c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 176 336 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grimace": [512, 512, [128556, "grimace"], "f57f", "M336.1 240c17.68 0 31.95-14.25 31.95-32s-14.27-32-31.95-32c-17.8 0-32.07 14.25-32.07 32S318.3 240 336.1 240zM335.1 272H176c-26.48 0-47.95 21.47-47.95 47.95L128 336c0 26.51 21.51 48 48.02 48h159.9c26.51 0 48.02-21.49 48.02-48L383.1 320C383.1 293.5 362.5 272 335.1 272zM184 352H176c-8.822 0-15.98-7.178-15.98-16L160 319.1C160 311.2 167.2 304 176 304h8V352zM240 352H216l.026-48H240V352zM296 352H272V304h23.97L296 352zM351.1 336c0 8.822-7.154 16-15.98 16H328V304h7.953c8.822 0 16.02 7.178 16.02 16L351.1 336zM175.9 240c17.8 0 32.07-14.25 32.07-32s-14.27-32-32.07-32c-17.68 0-31.95 14.25-31.95 32S158.3 240 175.9 240zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin": [512, 512, [128512, "grin"], "f580", "M336 240c17.68 0 31.97-14.25 31.97-32s-14.29-32-31.97-32c-17.8 0-32.09 14.25-32.09 32S318.2 240 336 240zM175.1 240c17.8 0 32.09-14.25 32.09-32s-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32S158.3 240 175.1 240zM361.6 304.6C335.7 312.9 297.2 317.8 256 317.8S176.4 312.9 150.4 304.6C140.5 301.5 131 310 132.7 319.9c7.871 47.13 71.32 80 123.3 80s115.3-32.88 123.3-80C380.8 310.1 371.6 301.5 361.6 304.6zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin-beam": [512, 512, [128516, "grin-beam"], "f582", "M144.5 210.9c7.75-13.75 19.25-21.62 31.48-21.62c12.35 0 23.86 7.875 31.48 21.62l9.566 17C219.1 231.7 223.2 232.8 226.3 231.8c3.512-1.125 5.934-4.5 5.691-8.375C228.8 181.3 199.8 152 175.1 152c-23.73 0-52.54 29.25-55.81 71.38C119.8 227.1 122.1 230.6 125.7 231.8c3.512 1 7.459-.575 9.397-3.825L144.5 210.9zM361.6 304.6C335.7 312.9 297.2 317.8 256 317.8S176.4 312.9 150.4 304.6C140.6 301.5 131 309.9 132.7 319.9c7.871 47.13 71.32 80 123.3 80s115.3-32.88 123.3-80C380.8 310.1 371.6 301.5 361.6 304.6zM336 152c-23.86 0-52.64 29.25-55.91 71.38c-.2422 3.75 2.034 7.25 5.546 8.375c3.512 1 7.459-.575 9.397-3.825l9.494-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.81 7.875 31.56 21.62l9.445 17c2.18 3.75 6.103 4.825 9.252 3.825c3.633-1.125 6.055-4.5 5.691-8.375C388.7 181.3 359.8 152 336 152zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin-beam-sweat": [512, 512, [128517, "grin-beam-sweat"], "f583", "M256 400c51.95 0 115.3-32.88 123.3-80c1.695-9.875-7.629-18.5-17.68-15.25C335.7 313 297.2 317.8 256 317.8S176.4 313 150.4 304.8C140.6 301.6 131 310 132.7 320C140.7 367.1 204.1 400 256 400zM176 189.3c12.35 0 23.86 7.875 31.48 21.62l9.566 17C219.1 231.7 223.2 232.8 226.3 231.8c3.512-1.125 5.934-4.5 5.691-8.375C228.8 181.3 199.8 152 175.1 152c-23.73 0-52.54 29.25-55.81 71.38C119.8 227.1 122.1 230.6 125.7 231.8c3.512 1 7.459-.575 9.397-3.825l9.445-17C152.3 197.2 163.8 189.3 176 189.3zM391.1 223.4c-3.27-42.13-32.22-71.37-55.96-71.37c-23.86 0-52.64 29.25-55.91 71.37c-.2422 3.75 2.034 7.25 5.546 8.375c3.512 1 7.459-.575 9.397-3.825l9.494-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.81 7.875 31.56 21.62l9.446 17c2.18 3.625 6.103 4.7 9.252 3.825C389.9 230.6 392.4 227.3 391.1 223.4zM456 176c-2.857 0-5.557-.5547-8.346-.8125C458.2 200 464 227.4 464 256c0 114.7-93.31 208-208 208S48 370.7 48 256S141.3 48 256 48c41.9 0 80.88 12.56 113.6 33.96c1.953-12.64 7.857-27.72 17.9-45.33C348.1 13.53 304.1 .0002 256 .0002C114.6 .0002 0 114.6 0 256s114.6 255.1 256 255.1S512 397.4 512 256c0-31.53-5.975-61.6-16.4-89.49C483.6 172.4 470.3 176 456 176zM456 144C486.9 144 512 120.4 512 91.14c0-22.5-33.31-67.91-48.54-87.45c-3.732-4.922-11.2-4.922-14.93 0C433.2 23.23 400 68.64 400 91.14C400 120.4 425.1 144 456 144z"],
    "face-grin-hearts": [512, 512, [128525, "grin-hearts"], "f584", "M361.6 304.6C335.7 312.9 297.2 317.8 256 317.8S176.4 312.9 150.4 304.6C140.6 301.5 131 309.9 132.7 319.9c7.871 47.25 71.32 80 123.3 80s115.3-32.88 123.3-80C380.8 310.1 371.6 301.5 361.6 304.6zM352.8 168.4L345.6 170.3l-2.059-7c-4.965-18.12-22.77-31-41.41-28c-21.43 3.5-34.39 24.25-28.82 44.5l19.38 70c1.211 4.5 5.934 7.125 10.54 6l70.11-18.25c20.46-5.25 31.97-26.88 24.22-47.13C390.9 172.8 370.9 163.8 352.8 168.4zM208.8 255.8c4.48 1.125 9.203-1.5 10.54-6l19.38-70c5.57-20.25-7.387-41-28.82-44.5c-18.53-3-36.33 9.875-41.41 28l-2.059 7L159.2 168.4c-18.16-4.625-38.14 4.375-44.8 22C106.7 210.6 118.2 232.3 138.7 237.6L208.8 255.8zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin-squint": [512, 512, [128518, "grin-squint"], "f585", "M361.6 304.6C335.7 312.9 297.2 317.8 256 317.8S176.4 312.9 150.4 304.6C140.5 301.5 131 310 132.7 319.9c7.871 47.13 71.32 80 123.3 80s115.3-32.88 123.3-80C380.8 310.1 371.6 301.5 361.6 304.6zM142.2 266.3l80.04-48C225.8 216.1 228 212.3 228 208S225.8 199.9 222.2 197.8l-80.04-48c-5.086-3-11.38-2-15.26 2.5c-3.754 4.5-3.754 11-.121 15.5L160.5 208l-33.66 40.25c-3.754 4.5-3.633 11.12 .121 15.5C130.5 268 136.8 269.5 142.2 266.3zM385.1 152.3c-3.754-4.5-10.17-5.5-15.26-2.5l-80.04 48C286.2 199.9 283.1 203.8 283.1 208s2.18 8.125 5.813 10.25l80.04 48C375.2 269.5 381.5 268 385.1 263.8c3.754-4.5 3.754-11 .1212-15.5L351.5 208l33.66-40.25C388.1 163.3 388.8 156.8 385.1 152.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin-squint-tears": [512, 512, [129315, "grin-squint-tears"], "f586", "M364.9 215.8c-12.25 24.25-36.13 54.74-65.26 83.86c-29.13 29.12-59.76 52.87-83.89 65.37c-9.252 4.75-10 17.5-1.752 23.37c38.88 27.75 107 6.248 143.8-30.62c36.63-36.75 58.26-104.7 30.5-143.6C382.5 205.9 369.8 206.5 364.9 215.8zM247.6 211.1l90.52-22.62c5.627-1.373 9.502-6.748 9.127-12.62c-.5-5.748-5.127-10.5-11-10.1l-52.26-4.75l-4.75-52.37c-.5-5.75-5.25-10.37-11-10.87C262.6 96.77 257 100.3 255.6 106L232.1 196.5c-1 4.125 .25 8.373 3.25 11.37C241.2 212.9 247.5 211.1 247.6 211.1zM207.9 236.3c-3-3-7.127-4.25-11.38-3.25L105.1 255.8c-5.75 1.375-9.502 6.623-9.127 12.5c.5 5.873 5.127 10.5 10.88 10.1L160.1 284.1l4.75 52.24c.5 5.875 5.252 10.37 11 10.87h.875c5.502 0 10.38-3.623 11.75-8.998l22.63-90.49C212.1 243.5 210.9 239.3 207.9 236.3zM394.9 127.9c25.88-3.625 84.01-13.62 100.9-30.62c22-21.87 21.5-57.87-.877-80.24c-22.38-22.37-58.26-22.75-80.26-.875c-16.88 16.87-26.88 75.12-30.63 100.9C383.3 123.4 388.6 128.8 394.9 127.9zM75.45 358.9C58.07 328.5 48 293.4 48 256c0-114.7 93.31-208 208-208c37.46 0 72.56 10.1 102.1 27.5c4.295-20.62 8.787-35.96 13.14-47.46C337.2 10.24 297.8 0 256 0C114.6 0 0 114.6 0 256c0 41.79 10.22 81.13 27.98 115.1C39.5 367.6 54.83 363.1 75.45 358.9zM484 140c-11.51 4.391-26.85 8.895-47.46 13.12C453.9 183.5 464 218.6 464 256c0 114.7-93.31 208-208 208c-37.46 0-72.56-10.1-102.1-27.5c-4.295 20.62-8.787 35.96-13.14 47.46C174.8 501.8 214.2 512 256 512c141.4 0 256-114.6 256-256C512 214.2 501.8 174.9 484 140zM117.1 384.1c-25.88 3.625-84.01 13.62-100.9 30.62c-22 21.87-21.5 57.87 .877 80.24c22.38 22.37 58.26 22.75 80.26 .875c16.88-16.87 26.88-75.12 30.63-100.9C128.7 388.6 123.4 383.2 117.1 384.1z"],
    "face-grin-stars": [512, 512, [129321, "grin-stars"], "f587", "M133.7 247.1C132.7 253.3 139.1 258.1 144.7 255l31.24-16.25L207.3 255C212.9 258.1 219.3 253.3 218.3 247.1l-6.055-34.88l25.43-24.62c4.48-4.5 1.938-12.25-4.359-13.25l-34.88-5l-15.5-31.62C180.1 132 171.1 132 169.1 137.8L153.6 169.4l-34.88 5C112.5 175.3 109.8 183 114.4 187.6l25.31 24.62L133.7 247.1zM361.6 304.6C335.7 312.9 297.2 317.8 256 317.8S176.4 312.9 150.4 304.6C140.6 301.5 131 309.9 132.7 319.9C140.6 367.1 204.1 399.9 256 399.9s115.3-32.94 123.3-80.06C380.8 310.1 371.6 301.5 361.6 304.6zM393.4 174.4l-34.1-5l-15.5-31.62c-2.785-5.75-10.9-5.75-13.8 0l-15.5 31.62l-34.1 5c-6.176 .875-8.84 8.625-4.238 13.25l25.43 24.62l-6.055 34.88c-.9687 6.125 5.449 11 11.02 7.875l31.24-16.25L367.4 255c5.57 3.125 11.99-1.75 11.02-7.875l-6.055-34.88l25.43-24.62C402.3 183 399.6 175.4 393.4 174.4zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin-tears": [640, 512, [128514, "grin-tears"], "f588", "M456 223.4C452.8 181.3 423.8 152 400 152c-23.75 0-52.66 29.25-55.91 71.38c-.25 3.75 2.077 7.25 5.702 8.375c3.5 1 7.364-.575 9.239-3.825l9.481-17c7.75-13.75 19.24-21.62 31.49-21.62c12.25 0 23.81 7.875 31.56 21.62l9.457 17c2.125 3.625 6.236 4.7 9.237 3.825C453.9 230.6 456.3 227.3 456 223.4zM240 189.3c12.25 0 23.74 7.875 31.49 21.62l9.554 17C283.2 231.7 287.2 232.8 290.2 231.8c3.627-1.125 6.098-4.5 5.848-8.375C292.8 181.3 263.7 152 239.1 152c-23.75 0-52.57 29.25-55.82 71.38C183.9 227.1 186.1 230.6 189.7 231.8c3.5 1 7.51-.575 9.385-3.825l9.457-17C216.3 197.2 227.8 189.3 240 189.3zM319.1 400c51.88 0 115.3-32.88 123.3-80c1.75-9.875-7.625-18.5-17.63-15.25c-25.88 8.25-64.38 13-105.6 13S240.4 313 214.4 304.8C204.6 301.6 194.1 310 196.7 320C204.7 367.1 268.1 400 319.1 400zM623.8 286.8c-16.88-17-75.01-27-100.9-30.62c-6.252-.875-11.63 4.5-10.75 10.75c3.625 25.88 13.63 84 30.63 100.9c21.88 22 57.88 21.5 80.26-.875C645.3 344.6 645.8 308.6 623.8 286.8zM117.1 256.1c-25.88 3.625-84.01 13.62-100.9 30.62c-22 21.88-21.5 57.88 .875 80.25s58.26 22.75 80.26 .875C114.2 351 124.2 292.8 127.1 267C128.7 260.6 123.3 255.3 117.1 256.1zM114.7 224.2C130.1 124.6 216.2 48 320 48c103.9 0 189.9 76.59 205.3 176.2l2.004 .2285c18.93 2.648 34.16 5.637 47.53 8.713C563.3 102.5 453.7 0 320 0C186.3 0 76.73 102.5 65.15 233.1c13.36-3.074 28.58-6.059 47.5-8.707L114.7 224.2zM500.9 358.3C465.1 421.3 397.5 464 320 464c-77.53 0-145.2-42.71-180.9-105.8c-8.195 20.89-15.6 28.76-19.1 32.26c-3.596 3.572-7.549 6.629-11.61 9.486C154.4 467.6 232 512 320 512c88.02 0 165.6-44.45 211.7-112.1c-4.074-2.883-8.029-5.977-11.62-9.584C516.6 386.9 509.1 378.1 500.9 358.3z"],
    "face-grin-tongue": [512, 512, [128539, "grin-tongue"], "f589", "M175.1 176c-17.68 0-31.97 14.25-31.97 32s14.29 32 31.97 32c17.8 0 32.09-14.25 32.09-32S193.8 176 175.1 176zM256 0C114.6 0 0 114.6 0 256c0 140.6 113.3 254.6 253.6 255.9c.3672 .0098 .707 .1113 1.074 .1172c.1484 0 .2656-.0163 .4141-.0163C255.4 511.1 255.8 512 256.1 512C397.5 512 512 397.4 512 256S397.4 0 256 0zM320.1 416c0 35.63-29.18 64.5-64.91 64c-35.12-.5-63.21-29.75-63.21-65v-50.75l17.8-8.875c15.02-7.5 31.48 1.75 34.88 16.5l2.785 12.12c2.059 9.25 15.26 9.25 17.32 0l2.785-12.12c3.391-14.75 19.74-24.12 34.88-16.5l17.68 8.875V416zM351.9 440.4l.1602-75.92c14.15-12.37 24.31-27.48 27.21-44.47c1.695-9.875-7.629-18.5-17.68-15.25C335.7 313 297.2 317.8 256 317.8s-79.56-4.75-105.6-13C140.5 301.6 131 310 132.7 320c2.904 16.99 13.07 32.1 27.21 44.47l.1699 75.92C93.58 405.7 48 336.1 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208C464 336.1 418.4 405.6 351.9 440.4zM336 176c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 176 336 176z"],
    "face-grin-tongue-squint": [512, 512, [128541, "grin-tongue-squint"], "f58a", "M385.1 152.3c-3.754-4.5-10.29-5.5-15.26-2.5l-80.04 48C286.2 199.9 283.1 203.8 283.1 208s2.18 8.125 5.812 10.25l80.04 48C375.2 269.5 381.5 268 385.1 263.8c3.754-4.5 3.754-11 .1211-15.5L351.5 208l33.66-40.25C388.1 163.3 388.8 156.6 385.1 152.3zM256 0C114.6 0 0 114.6 0 256c0 140.6 113.3 254.6 253.6 255.9c.3672 .0098 .707 .1113 1.074 .1172c.1484 0 .2656-.0163 .4141-.0163C255.4 511.1 255.8 512 256.1 512C397.5 512 512 397.4 512 256S397.4 0 256 0zM320.1 416c0 35.63-29.18 64.5-64.91 64c-35.12-.5-63.21-29.75-63.21-65v-50.75l17.8-8.875c15.02-7.5 31.48 1.75 34.88 16.5l2.785 12.12c2.059 9.25 15.26 9.25 17.32 0l2.785-12.12c3.391-14.75 19.74-24.12 34.88-16.5l17.68 8.875V416zM351.9 440.4l.1406-75.91c14.15-12.37 24.31-27.48 27.21-44.47c1.695-9.875-7.629-18.5-17.68-15.25C335.7 313 297.2 317.8 256 317.8s-79.56-4.75-105.6-13C140.5 301.6 131 310 132.7 320c2.904 16.99 13.07 32.1 27.21 44.47l.1504 75.91C93.57 405.6 48 336.1 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208C464 336.1 418.4 405.6 351.9 440.4zM142.2 149.8c-4.965-3-11.38-2-15.26 2.5c-3.754 4.5-3.754 11-.1211 15.5L160.5 208l-33.66 40.25c-3.754 4.5-3.633 11 .1211 15.5C130.5 268 136.8 269.5 142.2 266.3l80.04-48C225.8 216.1 228 212.3 228 208S225.8 199.9 222.2 197.8L142.2 149.8z"],
    "face-grin-tongue-wink": [512, 512, [128540, "grin-tongue-wink"], "f58b", "M159.1 180c-25.67 0-55.82 16.88-59.82 42.13c-.7266 5 1.695 10 6.176 12.38c4.359 2.375 9.93 1.75 13.68-1.625l9.445-8.5c14.89-13.12 46.26-13.12 61.03 0l9.566 8.5C202.5 235.1 208 237.6 213.7 234.5c4.359-2.375 6.902-7.375 6.055-12.38C215.9 196.9 185.6 180 159.1 180zM256 0C114.6 0 0 114.6 0 256c0 140.6 113.3 254.6 253.6 255.9c.3672 .0098 .707 .1113 1.074 .1172c.1484 0 .2656-.0163 .4141-.0163C255.4 511.1 255.8 512 256.1 512C397.5 512 512 397.4 512 256S397.4 0 256 0zM320.1 416c0 35.63-29.18 64.5-64.91 64c-35.12-.5-63.21-29.75-63.21-65v-50.75l17.8-8.875c15.02-7.5 31.48 1.75 34.88 16.5l2.785 12.12c2.059 9.25 15.26 9.25 17.32 0l2.785-12.12c3.391-14.75 19.74-24.12 34.88-16.5l17.68 8.875V416zM352 440.3l.0586-75.87c14.15-12.37 24.31-27.48 27.21-44.47c1.695-9.875-7.629-18.5-17.68-15.25C335.7 313 297.2 317.8 256 317.8s-79.56-4.75-105.6-13C140.5 301.6 131 310 132.7 320c2.904 16.99 13.07 32.1 27.21 44.47L160 440.3C93.53 405.6 48 336.1 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208C464 336.1 418.5 405.6 352 440.3zM336 128C291.8 128 256 163.8 256 208c0 44.25 35.84 80 80.04 80S415.1 252.3 415.1 208C415.1 163.8 380.2 128 336 128zM336 256c-26.52 0-48.07-21.5-48.07-48S309.5 160 336 160c26.4 0 47.95 21.5 47.95 48S362.4 256 336 256zM336 184c-13.32 0-24.04 10.75-24.04 24s10.72 24 24.04 24c13.2 0 23.97-10.75 23.97-24S349.2 184 336 184z"],
    "face-grin-wide": [512, 512, [128515, "grin-alt"], "f581", "M208.3 248C220.6 229.3 223.4 210.8 224 192c-.4844-18.75-3.391-37.25-15.74-56c-7.992-12-25.07-11.38-32.7 0C163.2 154.8 160.5 173.3 159.9 192c.6055 18.75 3.391 37.25 15.74 56C183.7 260 200.8 259.4 208.3 248zM361.6 304.6C335.7 312.9 297.2 317.8 256 317.8S176.4 312.9 150.4 304.6C140.5 301.5 131 309.9 132.7 319.9c7.871 47.25 71.32 80 123.3 80s115.3-32.88 123.3-80C380.8 310.1 371.6 301.5 361.6 304.6zM336.1 248c12.47-18.75 15.28-37.25 15.88-56c-.4844-18.75-3.412-37.25-15.88-56c-7.992-12-24.92-11.38-32.55 0C291.2 154.8 288.5 173.3 287.8 192c.6055 18.75 3.391 37.25 15.74 56C311.7 260 328.6 259.4 336.1 248zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-grin-wink": [512, 512, ["grin-wink"], "f58c", "M175.9 240c17.68 0 32.07-14.38 32.07-32s-14.39-32-32.07-32s-31.95 14.38-31.95 32S158.3 240 175.9 240zM361.6 304.6C335.7 313 297.2 317.8 256 317.8S176.3 313 150.4 304.6C140.5 301.5 131 310 132.7 320C140.7 367.1 204.1 400 256 400s115.3-32.88 123.3-80C380.1 310.1 371.6 301.5 361.6 304.6zM336 180.1c-25.79 0-55.85 16.88-59.85 42.13c-1.695 11.25 11.41 18.16 19.77 10.78l9.566-8.5c14.77-13.25 46.23-13.25 61 0L376 233c8.477 7.375 21.65 .3438 19.95-10.78C391.1 196.1 361.7 180.1 336 180.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-kiss": [512, 512, [128535, "kiss"], "f596", "M276.9 344.4C298.6 335.3 311.9 321 311.9 308c0-19.25-28.7-41.5-71.45-44C236.7 263.6 233.1 266.4 232.3 270.3C231.4 274 233.4 277.9 236.1 279.4l16.95 7.25c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5l-16.95 7.125c-5.691 2.5-5.934 12.25 0 14.88l16.95 7.125c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5L236.1 409c-3.633 1.5-5.57 5.375-4.723 9.25c.8477 3.5 4.117 6.125 7.871 6.125h.4844c42.75-2.5 71.45-24.75 71.45-44C312.1 367.4 298.7 353.1 276.9 344.4zM175.9 176c-17.68 0-31.97 14.25-31.97 32s14.29 32 31.97 32c17.8 0 32.09-14.25 32.09-32S193.7 176 175.9 176zM336.1 176c-17.8 0-32.07 14.25-32.07 32s14.27 32 32.07 32c17.68 0 31.95-14.25 31.95-32S353.7 176 336.1 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-kiss-beam": [512, 512, [128537, "kiss-beam"], "f597", "M176 152c-23.73 0-52.67 29.25-55.94 71.38C119.7 227.1 121.9 230.6 125.6 231.8c3.512 1 7.58-.575 9.397-3.825l9.445-17c7.75-13.75 19.18-21.62 31.53-21.62c12.23 0 23.73 7.875 31.48 21.62l9.518 17c2.059 3.75 6.103 4.825 9.252 3.825c3.633-1.125 5.934-4.5 5.57-8.375C228.8 181.3 199.9 152 176 152zM276.9 344.4C298.6 335.3 311.9 321 311.9 308c0-19.25-28.7-41.5-71.45-44C236.7 263.6 233.1 266.4 232.3 270.3C231.4 274 233.4 277.9 236.1 279.4l16.95 7.25c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5l-16.95 7.125c-5.691 2.5-5.934 12.25 0 14.88l16.95 7.125c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5L236.1 409c-3.633 1.5-5.57 5.375-4.723 9.25c.8477 3.5 4.117 6.125 7.871 6.125h.4844c42.75-2.5 71.45-24.75 71.45-44C312.1 367.4 298.7 353.1 276.9 344.4zM336 152c-23.86 0-52.72 29.25-55.99 71.38c-.2422 3.75 1.986 7.25 5.498 8.375c3.512 1 7.58-.575 9.397-3.825l9.566-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.73 7.875 31.48 21.62l9.445 17c2.18 3.75 6.224 4.825 9.252 3.825c3.633-1.125 5.934-4.5 5.57-8.375C388.7 181.3 359.8 152 336 152zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-kiss-wink-heart": [512, 512, [128536, "kiss-wink-heart"], "f598", "M366.4 224.5l9.566 8.5c8.477 7.375 21.55 .25 19.86-10.88C391.9 196.9 361.7 180 336 180c-25.79 0-55.95 16.88-59.94 42.13c-1.695 11.25 11.5 18.25 19.86 10.88l9.566-8.5C320.3 211.3 351.7 211.3 366.4 224.5zM342.2 445.1C315.9 457.1 286.8 464 256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208c0 24.24-4.385 47.43-12.04 69.08c5.838 5.277 11.15 11.15 15.21 18.06c9.578 .0332 18.64 2.279 27.27 5.51C505.6 319.9 512 288.7 512 256c0-141.4-114.6-256-256-256S0 114.6 0 256s114.6 256 256 256c35.92 0 70.07-7.461 101.1-20.81c-1.721-2.883-3.465-5.766-4.494-9.094L342.2 445.1zM253.9 401.8L236.1 409c-3.633 1.5-5.57 5.375-4.723 9.25c.8477 3.5 4.117 6.125 7.871 6.125h.4844c42.75-2.5 71.45-24.75 71.45-44c0-13-13.32-27.25-35.12-36C298.6 335.3 311.9 321 311.9 308c0-19.25-28.7-41.5-71.45-44C236.7 263.6 233.1 266.4 232.3 270.3C231.4 274 233.4 277.9 236.1 279.4l16.95 7.25c12.96 5.5 20.71 13.5 20.71 21.5s-7.75 16-20.71 21.5l-16.95 7.125c-5.691 2.5-5.934 12.25 0 14.88l16.95 7.125c12.96 5.5 20.71 13.5 20.71 21.5S266.9 396.3 253.9 401.8zM143.1 208c0 17.75 14.28 32 31.96 32c17.8 0 32.09-14.25 32.09-32s-14.29-32-32.09-32C158.3 176 143.1 190.3 143.1 208zM455.2 376.6l-8.5 2.125l-2.375-8.375c-6-21.38-27.38-36.5-49.75-33c-25.62 4-41.25 28.62-34.63 52.63l23.25 82.63c1.625 5.25 7.125 8.5 12.62 7.125l84.38-21.5c24.5-6.375 38.25-31.88 28.88-55.75C500.9 381.8 477 371 455.2 376.6z"],
    "face-laugh": [512, 512, ["laugh"], "f599", "M175.1 224c17.8 0 32.09-14.25 32.09-32S193.8 160 175.1 160C158.3 160 143.1 174.3 143.1 192S158.3 224 175.1 224zM336 224c17.68 0 31.97-14.25 31.97-32s-14.29-32-31.97-32c-17.8 0-32.09 14.25-32.09 32S318.2 224 336 224zM370.4 288H141.6c-8.113 0-14.41 7-13.44 15C135.6 362.3 186.1 408 249.2 408h13.56c62.24 0 113.6-45.75 121.1-105C384.8 295 378.5 288 370.4 288zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-laugh-beam": [512, 512, [128513, "laugh-beam"], "f59a", "M144.5 210.9C152.2 197.3 163.7 189.3 175.1 189.3c12.35 0 23.86 8 31.48 21.62l9.566 17c4.117 7.375 15.62 4 14.89-4.5C228.6 181.3 199.7 152 175.1 152c-23.86 0-52.82 29.25-56.09 71.38c-.6055 8.5 10.9 11.88 15.14 4.5L144.5 210.9zM370.4 288H141.6c-8.113 0-14.41 7-13.44 15C135.6 362.3 186.1 408 249.2 408h13.56c62.24 0 113.6-45.75 121.1-105C384.8 295 378.5 288 370.4 288zM336 152c-23.86 0-52.78 29.25-56.04 71.38C279.3 232 290.8 235.3 294.9 227.9l9.566-17c7.629-13.62 19.13-21.62 31.48-21.62c12.23 0 23.73 8 31.48 21.62l9.445 17c4.117 7.375 15.62 4 14.89-4.5C388.7 181.3 359.8 152 336 152zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-laugh-squint": [512, 512, ["laugh-squint"], "f59b", "M142.2 254.3l80.04-48c7.75-4.625 7.75-15.88 0-20.5l-80.04-48c-11.62-7-23.98 7.625-15.38 18L160.5 196l-33.66 40.25C118.1 246.8 130.5 261.1 142.2 254.3zM370.4 288H141.6c-8.113 0-14.41 7-13.44 15C135.6 362.3 186.1 408 249.2 408h13.56c62.24 0 113.6-45.75 121.1-105C384.8 295 378.5 288 370.4 288zM369.8 137.8l-80.04 48c-7.75 4.625-7.75 15.88 0 20.5l80.04 48c11.5 6.875 23.98-7.5 15.38-18L351.5 196l33.66-40.25C393.8 145.4 381.5 130.9 369.8 137.8zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-laugh-wink": [512, 512, ["laugh-wink"], "f59c", "M370.4 288H141.6c-8.113 0-14.41 7-13.44 15C135.6 362.3 186.1 408 249.2 408h13.56c62.24 0 113.6-45.75 121.1-105C384.8 295 378.5 288 370.4 288zM175.1 224c17.8 0 32.09-14.25 32.09-32S193.8 160 175.1 160C158.3 160 143.1 174.3 143.1 192S158.3 224 175.1 224zM336 164c-25.79 0-55.95 16.88-59.94 42.13c-1.695 11.12 11.5 18.12 19.74 10.75l9.566-8.5c14.77-13.12 46.14-13.12 61.03 0l9.445 8.5c8.477 7.375 21.68 .375 19.86-10.75C391.9 180.9 361.7 164 336 164zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-meh": [512, 512, [128528, "meh"], "f11a", "M344 320H167.1c-13.2 0-23.98 10.75-23.98 24s10.78 24 23.98 24h176.1c13.2 0 23.98-10.75 23.98-24S357.2 320 344 320zM175.1 240c17.8 0 32.02-14.25 32.02-32s-14.22-32-32.02-32c-17.68 0-31.99 14.25-31.99 32S158.3 240 175.1 240zM336 176c-17.8 0-32.02 14.25-32.02 32s14.22 32 32.02 32c17.68 0 31.99-14.25 31.99-32S353.7 176 336 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-meh-blank": [512, 512, [128566, "meh-blank"], "f5a4", "M336 176c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 176 336 176zM175.1 176c-17.68 0-31.97 14.25-31.97 32s14.29 32 31.97 32c17.8 0 32.09-14.25 32.09-32S193.8 176 175.1 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-rolling-eyes": [512, 512, [128580, "meh-rolling-eyes"], "f5a5", "M240 224c0-39.75-32.21-72-72.05-72C128.2 152 96.03 184.3 96.03 224s32.22 72 71.94 72C207.8 296 240 263.8 240 224zM128 224c0-13.62 7.266-25.12 17.68-32.25C144.7 194.3 143.1 197 143.1 200c0 13.25 10.66 24 23.98 24s23.98-10.75 23.98-24c0-2.875-.6055-5.75-1.695-8.25C200.7 198.9 208 210.4 208 224c0 22.12-17.9 40-40.06 40C145.9 264 128 246.1 128 224zM344 152c-39.84 0-72.05 32.25-72.05 72s32.21 72 72.05 72c39.72 0 71.94-32.25 71.94-72S383.8 152 344 152zM344 264c-22.16 0-40.06-17.88-40.06-40c0-13.62 7.363-25.12 17.78-32.25C320.7 194.3 320.1 197 320.1 200c0 13.25 10.66 24 23.98 24s23.98-10.75 23.98-24c0-2.875-.7266-5.75-1.695-8.25C376.7 198.9 383.1 210.4 383.1 224C383.1 246.1 366.1 264 344 264zM320.1 352H191.9c-13.2 0-23.98 10.75-23.98 24s10.78 24 23.98 24h128.1c13.2 0 23.98-10.75 23.98-24S333.3 352 320.1 352zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-sad-cry": [512, 512, [128557, "sad-cry"], "f5b3", "M256 272c-30.88 0-55.95 28.75-55.95 64s25.07 64 55.95 64s55.95-28.75 55.95-64S286.9 272 256 272zM352.1 180.1c-25.67 0-56.04 16.88-59.91 42.13c-.8477 5 1.695 10 6.055 12.38c4.48 2.375 9.93 1.75 13.68-1.625l9.657-8.594c14.77-13.12 46.05-13.12 60.94 0l9.536 8.5c2.543 2.25 7.992 4.75 13.68 1.625c4.48-2.375 6.902-7.281 6.176-12.28C407.9 196.1 377.8 180.1 352.1 180.1zM213.9 234.6c4.359-2.375 6.872-7.375 6.146-12.38c-3.996-25.25-34.36-42.13-59.91-42.13S104.1 196.1 100.2 222.2c-.7266 5 1.695 10 6.176 12.38c4.359 2.375 9.809 1.75 13.68-1.625l9.445-8.5c14.77-13.12 46.26-13.12 61.03 0l9.627 8.5C202.7 235.3 208 237.8 213.9 234.6zM256 0C114.8 0 0 114.8 0 256s114.8 256 256 256s256-114.8 256-256S397.2 0 256 0zM399.1 405.8V280c0-13.25-10.78-24-23.98-24s-23.99 10.75-23.99 24v160.3C323.3 455.4 290.6 464 256 464c-34.65 0-67.28-8.637-96.04-23.69L159.1 280c0-13.25-10.79-24-23.99-24S112 266.8 112 280l-.0137 125.7C72.64 367.9 48 314.8 48 256c0-114.7 93.31-208 208-208s208 93.31 208 208C464 314.8 439.4 367.9 399.1 405.8z"],
    "face-sad-tear": [512, 512, [128546, "sad-tear"], "f5b4", "M175.1 240c17.8 0 32.09-14.25 32.09-32s-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32S158.3 240 175.1 240zM170.4 274.8c-11.38 15.38-36.33 50.63-36.33 68.13C134.1 365.6 152.8 384 175.1 384c23.25 0 42.02-18.38 42.02-41.13c0-17.5-24.95-52.75-36.33-68.13C178.7 271.1 173.2 271.1 170.4 274.8zM336 176c-17.8 0-32.09 14.25-32.09 32s14.29 32 32.09 32c17.68 0 31.97-14.25 31.97-32S353.7 176 336 176zM263.1 304c-13.2 0-23.98 10.75-23.98 24S250.8 352 263.1 352c23.86 0 46.26 10.5 61.64 28.75c8.113 9.875 23.13 12 33.79 3.125c10.17-8.5 11.62-23.62 3.027-33.75C337.1 320.8 302.1 304 263.1 304zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-smile": [512, 512, [128578, "smile"], "f118", "M336 240c17.68 0 31.99-14.25 31.99-32s-14.31-32-31.99-32c-17.8 0-32.02 14.25-32.02 32S318.2 240 336 240zM175.1 240c17.8 0 32.02-14.25 32.02-32s-14.22-32-32.02-32c-17.68 0-31.99 14.25-31.99 32S158.3 240 175.1 240zM340 312.6C319.2 337.6 288.5 352 256 352s-63.21-14.25-84.04-39.38c-8.477-10.25-23.61-11.5-33.79-3.125C128 318 126.7 333.1 135.1 343.3c29.91 36 74.11 56.73 120.9 56.73s90.94-20.73 120.9-56.73c8.598-10.12 7.145-25.25-3.027-33.75C363.7 301.1 348.5 302.4 340 312.6zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-smile-beam": [512, 512, [128522, "smile-beam"], "f5b8", "M340 312.6C319.2 337.6 288.5 352 256 352s-63.21-14.25-84.04-39.38c-8.477-10.25-23.61-11.5-33.79-3.125C128 318 126.7 333.1 135.1 343.3c29.91 36 74.11 56.73 120.9 56.73s90.94-20.73 120.9-56.73c8.598-10.12 7.145-25.25-3.027-33.75C363.7 301.1 348.5 302.4 340 312.6zM144.5 210.9c7.75-13.75 19.25-21.62 31.48-21.62c12.35 0 23.86 7.875 31.48 21.62l9.566 17C219.1 231.7 223.2 232.8 226.3 231.8c3.512-1.125 5.934-4.5 5.691-8.375C228.8 181.3 199.8 152 175.1 152c-23.73 0-52.68 29.25-55.95 71.38C119.6 227.1 122.1 230.6 125.7 231.8c3.391 1 7.459-.575 9.397-3.825L144.5 210.9zM336 152c-23.86 0-52.72 29.25-55.99 71.38c-.2422 3.75 2.107 7.25 5.619 8.375c3.512 1 7.387-.575 9.324-3.825l9.566-17c7.629-13.75 19.13-21.62 31.48-21.62c12.23 0 23.73 7.875 31.48 21.62l9.445 17c2.18 3.75 6.176 4.825 9.324 3.825c3.633-1.125 6.127-4.5 5.764-8.375C388.8 181.3 359.8 152 336 152zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-smile-wink": [512, 512, [128521, "smile-wink"], "f4da", "M340 312.8C319.2 337.8 288.5 352.1 256 352.1s-63.21-14.38-84.04-39.38c-8.477-10.25-23.61-11.5-33.79-3.125c-10.17 8.5-11.5 23.62-3.027 33.75C165.1 379.4 209.3 400 256 400s90.94-20.62 120.9-56.63c8.598-10.12 7.145-25.25-3.027-33.75S348.5 302.5 340 312.8zM175.1 240c17.8 0 32.09-14.25 32.09-32s-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32S158.3 240 175.1 240zM336 180.1c-25.79 0-55.85 16.88-59.85 42.13c-1.695 11.12 11.5 18.12 19.74 10.75l9.566-8.5c14.77-13.12 46.14-13.12 61.03 0l9.354 8.406c8.477 7.375 21.86 .4687 20.04-10.66C392 196.1 361.7 180.1 336 180.1zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-surprise": [512, 512, [128558, "surprise"], "f5c2", "M256 280c-35.36 0-64.06 28.75-64.06 64s28.7 64 64.06 64s64.06-28.75 64.06-64S291.4 280 256 280zM208 208c0-17.75-14.29-32-32.09-32c-17.68 0-31.97 14.25-31.97 32s14.29 32 31.97 32C193.8 240 208 225.8 208 208zM336 176c-17.8 0-32.07 14.25-32.07 32s14.27 32 32.07 32c17.68 0 31.95-14.25 31.95-32S353.7 176 336 176zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "face-tired": [512, 512, [128555, "tired"], "f5c8", "M256 272c-45.41 0-100.9 38.25-107.8 93.25c-1.574 11.88 6.902 21.62 15.5 18C186.4 373.5 220 368 256 368s69.63 5.486 92.27 15.24c8.477 3.625 17.07-6 15.5-18C356.9 310.3 301.4 272 256 272zM228 208c0-4.25-2.18-8.125-5.812-10.25l-80.04-48c-4.965-3-11.5-2-15.26 2.5s-3.875 11-.1211 15.5L160.5 208l-33.66 40.25c-3.754 4.5-3.633 11 .1211 15.5c3.512 4.125 9.93 5.75 15.26 2.5l80.04-48C225.8 216.1 228 212.3 228 208zM385.1 152.3c-3.754-4.5-10.29-5.5-15.26-2.5l-80.04 48C286.2 199.9 283.1 203.8 283.1 208s2.18 8.125 5.812 10.25l80.04 48c5.328 3.25 11.75 1.625 15.26-2.5c3.754-4.5 3.875-11 .1211-15.5L351.5 208l33.66-40.25C388.1 163.3 388.8 156.6 385.1 152.3zM256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464z"],
    "file": [384, 512, [128459, 61462, 128196], "f15b", "M365.3 93.38l-74.63-74.64C278.6 6.743 262.3 0 245.4 0L64-.0001c-35.35 0-64 28.65-64 64l.0065 384c0 35.35 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM320 464H64.02c-8.836 0-15.1-7.163-16-15.1L48 64.13c-.0004-8.837 7.163-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1v288C336 456.8 328.8 464 320 464z"],
    "file-audio": [384, 512, [], "f1c7", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0L64-.0001c-35.35 0-64 28.65-64 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM171.5 259.5L136 296H92C85.38 296 80 301.4 80 308v56C80 370.7 85.38 376 92 376H136l35.5 36.5C179.1 420 192 414.8 192 404v-136C192 257.3 179.1 251.9 171.5 259.5zM235.1 260.7c-6.25 6.25-6.25 16.38 0 22.62C235.3 283.5 256 305.1 256 336c0 30.94-20.77 52.53-20.91 52.69c-6.25 6.25-6.25 16.38 0 22.62C238.2 414.4 242.3 416 246.4 416s8.188-1.562 11.31-4.688C258.1 410.1 288 380.5 288 336s-29.05-74.06-30.28-75.31C251.5 254.4 241.3 254.4 235.1 260.7z"],
    "file-code": [384, 512, [], "f1c9", "M162.1 257.8c-7.812-7.812-20.47-7.812-28.28 0l-48 48c-7.812 7.812-7.812 20.5 0 28.31l48 48C137.8 386.1 142.9 388 148 388s10.23-1.938 14.14-5.844c7.812-7.812 7.812-20.5 0-28.31L128.3 320l33.86-33.84C169.1 278.3 169.1 265.7 162.1 257.8zM365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM221.9 257.8c-7.812 7.812-7.812 20.5 0 28.31L255.7 320l-33.86 33.84c-7.812 7.812-7.812 20.5 0 28.31C225.8 386.1 230.9 388 236 388s10.23-1.938 14.14-5.844l48-48c7.812-7.812 7.812-20.5 0-28.31l-48-48C242.3 250 229.7 250 221.9 257.8z"],
    "file-excel": [384, 512, [], "f1c3", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM229.1 233.3L192 280.9L154.9 233.3C146.8 222.8 131.8 220.9 121.3 229.1C110.8 237.2 108.9 252.3 117.1 262.8L161.6 320l-44.53 57.25c-8.156 10.47-6.25 25.56 4.188 33.69C125.7 414.3 130.8 416 135.1 416c7.156 0 14.25-3.188 18.97-9.25L192 359.1l37.06 47.65C233.8 412.8 240.9 416 248 416c5.125 0 10.31-1.656 14.72-5.062c10.44-8.125 12.34-23.22 4.188-33.69L222.4 320l44.53-57.25c8.156-10.47 6.25-25.56-4.188-33.69C252.2 220.9 237.2 222.8 229.1 233.3z"],
    "file-image": [384, 512, [128443], "f1c5", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM215.3 292c-4.68 0-9.051 2.34-11.65 6.234L164 357.8l-11.68-17.53C149.7 336.3 145.3 334 140.7 334c-4.682 0-9.053 2.34-11.65 6.234l-46.67 70c-2.865 4.297-3.131 9.82-.6953 14.37C84.09 429.2 88.84 432 93.1 432h196c5.163 0 9.907-2.844 12.34-7.395c2.436-4.551 2.17-10.07-.6953-14.37l-74.67-112C224.4 294.3 220 292 215.3 292zM128 288c17.67 0 32-14.33 32-32S145.7 224 128 224S96 238.3 96 256S110.3 288 128 288z"],
    "file-lines": [384, 512, [128462, 61686, 128441, "file-alt", "file-text"], "f15c", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0L64-.0001c-35.35 0-64 28.65-64 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM96 280C96 293.3 106.8 304 120 304h144C277.3 304 288 293.3 288 280S277.3 256 264 256h-144C106.8 256 96 266.8 96 280zM264 352h-144C106.8 352 96 362.8 96 376s10.75 24 24 24h144c13.25 0 24-10.75 24-24S277.3 352 264 352z"],
    "file-pdf": [384, 512, [], "f1c1", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM202 286.1c.877-2.688 1.74-5.398 2.582-8.145c1.434-5.762 7.488-31.54 7.488-52.47C212.1 207 197.1 192 178.6 192C160.1 192 145.1 207 145.1 225.5c0 .2969 .1641 28.81 13.85 62.3c-7.035 19.36-15.57 38.8-25.41 57.93c-21.49 10.11-39.24 22.23-52.8 36.07c-6.234 6.438-9.367 14.74-9.367 24.72c0 18.45 15.01 33.46 33.46 33.46c10.8 0 20.98-5.227 27.22-13.98c7.322-10.28 18.38-26.9 30.47-48.95c15.8-6.352 33.88-11.72 53.88-16c13.55 9.578 28.9 17.29 45.71 22.95c4.527 1.551 9.402 2.348 14.43 2.348c20.26 0 36.13-16.19 36.13-36.86c0-20.33-16.54-36.87-36.87-36.87h-3.705c-2.727 .125-20.51 1.141-45.37 5.367C216.9 308.9 208.6 298.3 202 286.1zM110.2 410.4c-3.273 4.688-12.03 2.777-12.03-5.312c0-1.754 .6289-3.43 1.729-4.555c9.02-9.219 19.94-17.05 31.85-23.72C122.3 393.1 114.3 404.7 110.2 410.4zM178.6 218.8c3.693 0 6.703 3.008 6.703 6.703c0 15.21-4.109 34.84-5.746 42.1C172.1 245 171.9 227.2 171.9 225.5C171.9 221.8 174.9 218.8 178.6 218.8zM162.3 348.3c6.611-13.48 13.22-28.46 19.38-44.7c6.389 10.92 14.56 21.86 24.96 31.97C192.6 338.8 177.4 342.9 162.3 348.3zM272.4 339.5h3.352c5.539 0 10.05 4.5 10.05 10.79c0 5.129-4.176 9.32-9.32 9.32c-2.029 0-4.059-.3164-5.852-.9414c-12.33-4.137-23.11-9.32-32.54-15.19C258.3 340.3 272.1 339.5 272.4 339.5z"],
    "file-powerpoint": [384, 512, [], "f1c4", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM200 224H128C119.2 224 112 231.2 112 240v168c0 13.25 10.75 24 24 24S160 421.3 160 408v-32h44c44.21 0 79.73-37.95 75.69-82.98C276.1 253.2 240 224 200 224zM204 328H160V272h44c15.44 0 28 12.56 28 28S219.4 328 204 328z"],
    "file-video": [384, 512, [], "f1c8", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM240 288c0-17.67-14.33-32-32-32h-96c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h96c17.67 0 32-14.33 32-32v-16.52l43.84 30.2C292.3 403.5 304 397.6 304 387.4V284.6c0-10.16-11.64-16.16-20.16-10.32L240 304.5V288z"],
    "file-word": [384, 512, [], "f1c2", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0H64C28.65 0 0 28.65 0 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h160L224 128c0 17.67 14.33 32 32 32h79.1V448zM214.6 248C211.3 238.4 202.2 232 192 232s-19.25 6.406-22.62 16L144.7 318.1l-25.89-77.66C114.6 227.8 101 221.2 88.41 225.2C75.83 229.4 69.05 243 73.23 255.6l48 144C124.5 409.3 133.5 415.9 143.8 416c10.17 0 19.45-6.406 22.83-16L192 328.1L217.4 400C220.8 409.6 229.8 416 240 416c10.27-.0938 19.53-6.688 22.77-16.41l48-144c4.188-12.59-2.594-26.16-15.17-30.38c-12.61-4.125-26.2 2.594-30.36 15.19l-25.89 77.66L214.6 248z"],
    "file-zipper": [384, 512, ["file-archive"], "f1c6", "M365.3 93.38l-74.63-74.64C278.6 6.742 262.3 0 245.4 0L64-.0001c-35.35 0-64 28.65-64 64l.0065 384c0 35.34 28.65 64 64 64H320c35.2 0 64-28.8 64-64V138.6C384 121.7 377.3 105.4 365.3 93.38zM336 448c0 8.836-7.164 16-16 16H64.02c-8.838 0-16-7.164-16-16L48 64.13c0-8.836 7.164-16 16-16h48V64h64V48.13h48.01L224 128c0 17.67 14.33 32 32 32h79.1V448zM176 96h-64v32h64V96zM176 160h-64v32h64V160zM176 224h-64l-30.56 116.5C73.51 379.5 103.7 416 144.3 416c40.26 0 70.45-36.3 62.68-75.15L176 224zM160 368H128c-8.836 0-16-7.164-16-16s7.164-16 16-16h32c8.836 0 16 7.164 16 16S168.8 368 160 368z"],
    "flag": [512, 512, [61725, 127988], "f024", "M476.3 0c-6.365 0-13.01 1.35-19.34 4.233c-45.69 20.86-79.56 27.94-107.8 27.94c-59.96 0-94.81-31.86-163.9-31.87c-34.63 0-77.87 8.003-137.2 32.05V24C48 10.75 37.25 0 24 0S0 10.75 0 24v464C0 501.3 10.75 512 24 512s24-10.75 24-24v-104c53.59-23.86 96.02-31.81 132.8-31.81c73.63 0 124.9 31.78 198.6 31.78c31.91 0 68.02-5.971 111.1-23.09C504.1 355.9 512 344.4 512 332.1V30.73C512 11.1 495.3 0 476.3 0zM464 319.8c-30.31 10.82-58.08 16.1-84.6 16.1c-30.8 0-58.31-7-87.44-14.41c-32.01-8.141-68.29-17.37-111.1-17.37c-42.35 0-85.99 9.09-132.8 27.73V84.14l18.03-7.301c47.39-19.2 86.38-28.54 119.2-28.54c28.24 .0039 49.12 6.711 73.31 14.48c25.38 8.148 54.13 17.39 90.58 17.39c35.43 0 72.24-8.496 114.9-26.61V319.8z"],
    "floppy-disk": [448, 512, [128426, 128190, "save"], "f0c7", "M224 256c-35.2 0-64 28.8-64 64c0 35.2 28.8 64 64 64c35.2 0 64-28.8 64-64C288 284.8 259.2 256 224 256zM433.1 129.1l-83.9-83.9C341.1 37.06 328.8 32 316.1 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V163.9C448 151.2 442.9 138.9 433.1 129.1zM128 80h144V160H128V80zM400 416c0 8.836-7.164 16-16 16H64c-8.836 0-16-7.164-16-16V96c0-8.838 7.164-16 16-16h16v104c0 13.25 10.75 24 24 24h192C309.3 208 320 197.3 320 184V83.88l78.25 78.25C399.4 163.2 400 164.8 400 166.3V416z"],
    "folder": [512, 512, [128447, 61716, 128193], "f07b", "M448 96h-172.1L226.7 50.75C214.7 38.74 198.5 32 181.5 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h384c35.35 0 64-28.66 64-64V160C512 124.7 483.3 96 448 96zM64 80h117.5c4.273 0 8.293 1.664 11.31 4.688L256 144h192c8.822 0 16 7.176 16 16v32h-416V96C48 87.18 55.18 80 64 80zM448 432H64c-8.822 0-16-7.176-16-16V240h416V416C464 424.8 456.8 432 448 432z"],
    "folder-open": [576, 512, [128449, 61717, 128194], "f07c", "M572.6 270.3l-96 192C471.2 473.2 460.1 480 447.1 480H64c-35.35 0-64-28.66-64-64V96c0-35.34 28.65-64 64-64h117.5c16.97 0 33.25 6.742 45.26 18.75L275.9 96H416c35.35 0 64 28.66 64 64v32h-48V160c0-8.824-7.178-16-16-16H256L192.8 84.69C189.8 81.66 185.8 80 181.5 80H64C55.18 80 48 87.18 48 96v288l71.16-142.3C124.6 230.8 135.7 224 147.8 224h396.2C567.7 224 583.2 249 572.6 270.3z"],
    "font-awesome": [448, 512, [62694, 61964, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M448 48V384c-63.09 22.54-82.34 32-119.5 32c-62.82 0-86.6-32-149.3-32c-21.69 0-38.48 3.791-53.74 8.766C110.1 397.5 96 386.1 96 371.7v-.7461c0-9.275 5.734-17.6 14.42-20.86C129.1 342.8 150.2 336 179.2 336c62.73 0 86.51 32 149.3 32c25.5 0 42.85-4.604 71.47-14.7v-240C379.2 120.6 357.7 128 328.5 128c-.0039 0 .0039 0 0 0c-62.81 0-86.61-32-149.3-32C122.1 96 98.8 122.1 48 126.1V456C48 469.3 37.25 480 24 480S0 469.3 0 456V56C0 42.74 10.75 32 24 32S48 42.74 48 56v22.99C98.8 74.14 122.1 48 179.2 48c62.77 0 86.45 32 149.3 32C366.1 80 386.8 69.85 448 48z"],
    "futbol": [512, 512, [9917, "futbol-ball", "soccer-ball"], "f1e3", "M177.1 228.6L207.9 320h96.5l29.62-91.38L256 172.1L177.1 228.6zM255.1 0C114.6 0 .0001 114.6 .0001 256S114.6 512 256 512s255.1-114.6 255.1-255.1S397.4 0 255.1 0zM435.2 361.1l-103.9-1.578l-30.67 99.52C286.2 462.2 271.3 464 256 464s-30.19-1.773-44.56-4.93L180.8 359.6L76.83 361.1c-14.93-25.35-24.79-54.01-27.8-84.72L134.3 216.4L100.7 118.1c19.85-22.34 44.32-40.45 72.04-52.62L256 128l83.29-62.47c27.72 12.17 52.19 30.27 72.04 52.62L377.7 216.4l85.23 59.97C459.1 307.1 450.1 335.8 435.2 361.1z"],
    "gem": [512, 512, [128142], "f3a5", "M507.9 196.4l-104-153.8C399.4 35.95 391.1 32 384 32H127.1C120 32 112.6 35.95 108.1 42.56l-103.1 153.8c-6.312 9.297-5.281 21.72 2.406 29.89l231.1 246.2C243.1 477.3 249.4 480 256 480s12.94-2.734 17.47-7.547l232-246.2C513.2 218.1 514.2 205.7 507.9 196.4zM382.5 96.59L446.1 192h-140.1L382.5 96.59zM256 178.9L177.6 80h156.7L256 178.9zM129.5 96.59L205.1 192H65.04L129.5 96.59zM256 421L85.42 240h341.2L256 421z"],
    "hand": [512, 512, [129306, 9995, "hand-paper"], "f256", "M408 80c-3.994 0-7.91 .3262-11.73 .9551c-9.586-28.51-36.57-49.11-68.27-49.11c-6.457 0-12.72 .8555-18.68 2.457C296.6 13.73 273.9 0 248 0C222.1 0 199.3 13.79 186.6 34.44C180.7 32.85 174.5 32 168.1 32C128.4 32 96.01 64.3 96.01 104v121.6C90.77 224.6 85.41 224 80.01 224c-.0026 0 .0026 0 0 0C36.43 224 0 259.2 0 304.1c0 20.29 7.558 39.52 21.46 54.45l81.25 87.24C141.9 487.9 197.4 512 254.9 512h33.08C393.9 512 480 425.9 480 320V152C480 112.3 447.7 80 408 80zM432 320c0 79.41-64.59 144-143.1 144H254.9c-44.41 0-86.83-18.46-117.1-50.96l-79.76-85.63c-6.202-6.659-9.406-15.4-9.406-23.1c0-22.16 18.53-31.4 31.35-31.4c8.56 0 17.1 3.416 23.42 10.18l26.72 28.69C131.8 312.7 133.9 313.4 135.9 313.4c4.106 0 8.064-3.172 8.064-8.016V104c0-13.25 10.75-24 23.1-24c13.25 0 23.1 10.75 23.1 24v152C192 264.8 199.2 272 208 272s15.1-7.163 15.1-15.1L224 72c0-13.25 10.75-24 23.1-24c13.25 0 23.1 10.75 23.1 24v184C272 264.8 279.2 272 288 272s15.99-7.164 15.99-15.1l.0077-152.2c0-13.25 10.75-24 23.1-24c13.25 0 23.1 10.75 23.1 24v152.2C352 264.8 359.2 272 368 272s15.1-7.163 15.1-15.1V152c0-13.25 10.75-24 23.1-24c13.25 0 23.1 10.75 23.1 24V320z"],
    "hand-back-fist": [448, 512, ["hand-rock"], "f255", "M377.1 68.05C364.4 50.65 343.7 40 321.2 40h-13.53c-3.518 0-7.039 .2754-10.53 .8184C284.8 31.33 269.6 26 253.5 26H240c-3.977 0-7.904 .3691-11.75 1.084C216.7 10.71 197.6 0 176 0H160C124.7 0 96 28.65 96 64v49.71L63.04 143.3C43.3 160 32 184.6 32 210.9v78.97c0 32.1 17.11 61.65 44.65 77.12L112 386.9v101.1C112 501.3 122.7 512 135.1 512S160 501.3 160 488v-129.9c-1.316-.6543-2.775-.9199-4.062-1.639l-55.78-31.34C87.72 318.2 80 304.6 80 289.9V210.9c0-12.31 5.281-23.77 14.5-31.39L112 163.8V208C112 216.8 119.2 224 128 224s16-7.156 16-16V64c0-8.828 7.188-16 16-16h16C184.8 48 192 55.17 192 64v16c0 9.578 7.942 16.04 16.15 16.04c6.432 0 12.31-4.018 14.73-10.17C223.3 84.84 228.3 74 240 74h13.53c20.97 0 17.92 19.58 34.27 19.58c8.177 0 9.9-5.584 19.88-5.584h13.53c25.54 0 18.27 28.23 38.66 28.23c.1562 0 .3125-.002 .4668-.0078L375.4 116C388.1 116 400 127.7 400 142V272c0 36.15-19.54 67.32-48 83.69v132.3C352 501.3 362.7 512 375.1 512S400 501.3 400 488v-108.1C430.1 352.8 448 313.6 448 272V142C448 102.1 416.8 69.44 377.1 68.05z"],
    "hand-lizard": [512, 512, [], "f258", "M512 331.8V424c0 13.25-10.75 24-24 24c-13.25 0-24-10.75-24-24v-92.17c0-10.09-3.031-19.8-8.766-28.08l-118.6-170.5C327.4 119.1 312.2 112 295.1 112H53.32c-2.5 0-5.25 2.453-5.313 4.172c-.2969 9.5 3.156 18.47 9.75 25.28C64.36 148.3 73.2 152 82.67 152h161.8c17.09 0 33.4 8.281 43.4 22.14c9.984 13.88 12.73 31.83 7.328 48.05l-9.781 29.34C278.2 273.3 257.8 288 234.9 288H138.7C129.2 288 120.4 291.8 113.8 298.5c-6.594 6.812-10.05 15.78-9.75 25.28C104.1 325.5 106.8 328 109.3 328h156.6c5.188 0 10.14 1.688 14.3 4.797l78.22 58.67c6.031 4.531 9.594 11.66 9.594 19.2L367.1 424c0 13.25-10.75 24-24 24s-24-10.75-24-24v-1.328L257.8 376H109.3c-28.48 0-52.39-22.72-53.28-50.64c-.7187-22.61 7.531-43.98 23.23-60.2C94.1 248.9 116.1 240 138.7 240h96.19c2.297 0 4.328-1.469 5.063-3.656l9.781-29.33c.7031-2.141-.0156-3.797-.7344-4.797C248.2 201.2 246.9 200 244.6 200H82.67c-22.58 0-43.67-8.938-59.39-25.16C7.575 158.6-.6755 137.3 .0433 114.6C.9339 86.72 24.84 64 53.32 64h242.7c31.94 0 61.86 15.67 80.05 41.92l118.6 170.5C506 292.8 512 311.9 512 331.8z"],
    "hand-peace": [512, 512, [9996], "f25b", "M412 160c-8.326 0-16.3 1.51-23.68 4.27C375.1 151.8 358.9 144 340 144c-11.64 0-22.44 3.223-32.03 8.418l11.12-68.95c.6228-3.874 .9243-7.725 .9243-11.53c0-36.08-28.91-71.95-72.09-71.95c-34.68 0-65.31 25.16-71.03 60.54L173.4 82.22L168.9 72.77c-12.4-25.75-38.07-40.78-64.89-40.78c-40.8 0-72.01 33.28-72.01 72.07c0 10.48 2.296 21.11 7.144 31.18L89.05 238.9C64.64 250.4 48 275.7 48 303.1v80c0 22.06 10.4 43.32 27.83 56.86l45.95 35.74c29.35 22.83 65.98 35.41 103.2 35.41l78.81 .0352C400.9 512 480 432.1 480 335.8v-107.5C480 189.6 447.9 160 412 160zM320 212.3C320 201.1 328.1 192 340 192c11.02 0 20 9.078 20 20.25v55.5C360 278.9 351 288 340 288C328.1 288 320 278.9 320 267.8V212.3zM247.9 47.98c12.05 0 24.13 9.511 24.13 23.98c0 1.277-.1022 2.57-.3134 3.871L248.4 220.5C240.7 217.6 232.4 215.1 223.9 215.1c0 0 .002 0 0 0c-4.475 0-8.967 .4199-13.38 1.254l-10.55 1.627l24.32-150.7C226.2 56.42 236.4 47.98 247.9 47.98zM79.1 104c0-13.27 10.79-24.04 24.02-24.04c8.937 0 17.5 5.023 21.61 13.61l61.29 127.3L137.3 228.5L82.38 114.4C80.76 111.1 79.1 107.5 79.1 104zM303.8 464l-78.81-.0352c-26.56 0-52.72-8.984-73.69-25.3l-45.97-35.75C99.47 398.4 96 391.3 96 383.1v-80c0-11.23 7.969-21.11 17.59-23.22l105.3-16.23C220.6 264.2 222.3 263.1 223.9 263.1c11.91 0 24.09 9.521 24.09 24.06c0 11.04-7.513 20.95-17.17 23.09L172.8 319c-12.03 1.633-20.78 11.92-20.78 23.75c0 20.21 18.82 24.08 23.7 24.08c2.645 0 64.61-8.619 65.54-8.826c23.55-5.227 41.51-22.23 49.73-43.64C303.3 327.5 320.6 336 340 336c8.326 0 16.31-1.51 23.69-4.27C376 344.2 393.1 352 412 352c.1992 0 10.08-.4453 18.65-2.92C423.9 413.5 369.9 464 303.8 464zM432 283.8C432 294.9 423 304 412 304c-11.02 0-20-9.078-20-20.25v-55.5C392 217.1 400.1 208 412 208c11.02 0 20 9.078 20 20.25V283.8z"],
    "hand-point-down": [448, 512, [], "f0a7", "M448 248V144C448 64.6 385.1 0 307.7 0H199.8C176.4 0 153.1 6.104 132.5 17.65L76.63 49C49.1 64.47 32 94.02 32 126.1V176c0 27.23 12.51 51.53 32 67.69V440C64 479.7 96.3 512 136 512s72-32.3 72-72v-56.44C210.6 383.9 213.3 384 216 384c25.95 0 48.73-13.79 61.4-34.43C283.3 351.2 289.6 352 296 352c25.95 0 48.73-13.79 61.4-34.43C363.3 319.2 369.6 320 376 320C415.7 320 448 287.7 448 248zM272 232c0-13.23 10.78-24 24-24S320 218.9 320 232.1V280c0 13.23-10.78 24-24 24S272 293.2 272 280V232zM192 264h12c12.39 0 23.93-3.264 34.27-8.545C239.3 258.1 240 260.1 240 264v48c0 13.23-10.78 24-24 24S192 325.2 192 312V264zM112 264c0-.2813 .1504-.5137 .1602-.793C114.8 263.4 117.3 264 120 264H160v176c0 13.23-10.78 24-24 24S112 453.2 112 440V264zM397.9 123.8C390.9 121.6 383.7 120 376 120c-29.04 0-53.96 17.37-65.34 42.18C305.8 161.2 301 160 296 160c-7.139 0-13.96 1.273-20.46 3.355C265.2 133.6 237.2 112 204 112H152C138.8 112 128 122.8 128 136S138.8 160 152 160h52c15.44 0 28 12.56 28 28S219.4 216 204 216H120C97.94 216 80 198.1 80 176V126.1c0-14.77 7.719-28.28 20.16-35.27l55.78-31.34C169.4 51.98 184.6 48 199.8 48h107.9C351.9 48 388.9 80.56 397.9 123.8zM400 248c0 13.23-10.78 24-24 24S352 261.2 352 248V192c0-13.23 10.78-24 24-24S400 178.8 400 192V248z"],
    "hand-point-left": [512, 512, [], "f0a5", "M264 480h104c79.4 0 144-62.95 144-140.3V231.8c0-23.44-6.104-46.73-17.65-67.35L462.1 108.6C447.5 81.1 417.1 64 385.9 64H336c-27.23 0-51.53 12.51-67.69 32H72C32.3 96 0 128.3 0 168S32.3 240 72 240h56.44C128.1 242.6 128 245.3 128 248c0 25.95 13.79 48.73 34.43 61.4C160.8 315.3 160 321.6 160 328c0 25.95 13.79 48.73 34.43 61.4C192.8 395.3 192 401.6 192 408C192 447.7 224.3 480 264 480zM280 304c13.23 0 24 10.78 24 24S293.1 352 279.9 352H232c-13.23 0-24-10.78-24-24S218.8 304 232 304H280zM248 224v12c0 12.39 3.264 23.93 8.545 34.27C253.9 271.3 251 272 248 272h-48C186.8 272 176 261.2 176 248S186.8 224 200 224H248zM248 144c.2813 0 .5137 .1504 .793 .1602C248.6 146.8 248 149.3 248 152V192h-176C58.77 192 48 181.2 48 168S58.77 144 72 144H248zM388.2 429.9C390.4 422.9 392 415.7 392 408c0-29.04-17.37-53.96-42.18-65.34C350.8 337.8 352 333 352 328c0-7.139-1.273-13.96-3.355-20.46C378.4 297.2 400 269.2 400 236V184C400 170.8 389.3 160 376 160S352 170.8 352 184v52c0 15.44-12.56 28-28 28S296 251.4 296 236V152c0-22.06 17.94-40 40-40h49.88c14.77 0 28.28 7.719 35.27 20.16l31.34 55.78C460 201.4 464 216.6 464 231.8v107.9C464 383.9 431.4 420.9 388.2 429.9zM264 432c-13.23 0-24-10.78-24-24S250.8 384 264 384H320c13.23 0 24 10.78 24 24S333.2 432 320 432H264z"],
    "hand-point-right": [512, 512, [], "f0a4", "M320 408c0-6.428-.8457-12.66-2.434-18.6C338.2 376.7 352 353.9 352 328c0-6.428-.8457-12.66-2.434-18.6C370.2 296.7 384 273.9 384 248c0-2.705-.1484-5.373-.4414-8H440C479.7 240 512 207.7 512 168S479.7 96 440 96H243.7C227.5 76.51 203.2 64 176 64H126.1C94.02 64 64.47 81.1 49 108.6L17.65 164.5C6.104 185.1 0 208.4 0 231.8v107.9C0 417.1 64.6 480 144 480h104C287.7 480 320 447.7 320 408zM280 304c13.23 0 24 10.78 24 24S293.2 352 280 352H232.1C218.9 352 208 341.2 208 328S218.8 304 232 304H280zM312 224c13.23 0 24 10.78 24 24S325.2 272 312 272h-48c-3.029 0-5.875-.7012-8.545-1.73C260.7 259.9 264 248.4 264 236V224H312zM440 144c13.23 0 24 10.78 24 24S453.2 192 440 192h-176V152c0-2.686-.5566-5.217-.793-7.84C263.5 144.2 263.7 144 264 144H440zM48 339.7V231.8c0-15.25 3.984-30.41 11.52-43.88l31.34-55.78C97.84 119.7 111.4 112 126.1 112H176c22.06 0 40 17.94 40 40v84c0 15.44-12.56 28-28 28S160 251.4 160 236V184C160 170.8 149.3 160 136 160S112 170.8 112 184v52c0 33.23 21.58 61.25 51.36 71.54C161.3 314 160 320.9 160 328c0 5.041 1.166 9.836 2.178 14.66C137.4 354 120 378.1 120 408c0 7.684 1.557 14.94 3.836 21.87C80.56 420.9 48 383.9 48 339.7zM192 432c-13.23 0-24-10.78-24-24S178.8 384 192 384h56c13.23 0 24 10.78 24 24s-10.77 24-24 24H192z"],
    "hand-point-up": [448, 512, [9757], "f0a6", "M376 192c-6.428 0-12.66 .8457-18.6 2.434C344.7 173.8 321.9 160 296 160c-6.428 0-12.66 .8457-18.6 2.434C264.7 141.8 241.9 128 216 128C213.3 128 210.6 128.1 208 128.4V72C208 32.3 175.7 0 136 0S64 32.3 64 72v196.3C44.51 284.5 32 308.8 32 336v49.88c0 32.1 17.1 61.65 44.63 77.12l55.83 31.35C153.1 505.9 176.4 512 199.8 512h107.9C385.1 512 448 447.4 448 368V264C448 224.3 415.7 192 376 192zM272 232c0-13.23 10.78-24 24-24S320 218.8 320 232v47.91C320 293.1 309.2 304 296 304S272 293.2 272 280V232zM192 200C192 186.8 202.8 176 216 176s24 10.77 24 24v48c0 3.029-.7012 5.875-1.73 8.545C227.9 251.3 216.4 248 204 248H192V200zM112 72c0-13.23 10.78-24 24-24S160 58.77 160 72v176H120c-2.686 0-5.217 .5566-7.84 .793C112.2 248.5 112 248.3 112 248V72zM307.7 464H199.8c-15.25 0-30.41-3.984-43.88-11.52l-55.78-31.34C87.72 414.2 80 400.6 80 385.9V336c0-22.06 17.94-40 40-40h84c15.44 0 28 12.56 28 28S219.4 352 204 352H152C138.8 352 128 362.8 128 376s10.75 24 24 24h52c33.23 0 61.25-21.58 71.54-51.36C282 350.7 288.9 352 296 352c5.041 0 9.836-1.166 14.66-2.178C322 374.6 346.1 392 376 392c7.684 0 14.94-1.557 21.87-3.836C388.9 431.4 351.9 464 307.7 464zM400 320c0 13.23-10.78 24-24 24S352 333.2 352 320V264c0-13.23 10.78-24 24-24s24 10.77 24 24V320z"],
    "hand-pointer": [448, 512, [], "f25a", "M208 288C199.2 288 192 295.2 192 304v96C192 408.8 199.2 416 208 416s16-7.164 16-16v-96C224 295.2 216.8 288 208 288zM272 288C263.2 288 256 295.2 256 304v96c0 8.836 7.162 16 15.1 16S288 408.8 288 400l-.0013-96C287.1 295.2 280.8 288 272 288zM376.9 201.2c-13.74-17.12-34.8-27.45-56.92-27.45h-13.72c-3.713 0-7.412 .291-11.07 .8652C282.7 165.1 267.4 160 251.4 160h-11.44V72c0-39.7-32.31-72-72.01-72c-39.7 0-71.98 32.3-71.98 72v168.5C84.85 235.1 75.19 235.4 69.83 235.4c-44.35 0-69.83 37.23-69.83 69.85c0 14.99 4.821 29.51 13.99 41.69l78.14 104.2C120.7 489.3 166.2 512 213.7 512h109.7c6.309 0 12.83-.957 18.14-2.645c28.59-5.447 53.87-19.41 73.17-40.44C436.1 446.3 448 416.2 448 384.2V274.3C448 234.6 416.3 202.3 376.9 201.2zM400 384.2c0 19.62-7.219 38.06-20.44 52.06c-12.53 13.66-29.03 22.67-49.69 26.56C327.4 463.6 325.3 464 323.4 464H213.7c-32.56 0-63.65-15.55-83.18-41.59L52.36 318.2C49.52 314.4 48.02 309.8 48.02 305.2c0-16.32 14.5-21.75 21.72-21.75c4.454 0 12.01 1.55 17.34 8.703l28.12 37.5c3.093 4.105 7.865 6.419 12.8 6.419c11.94 0 16.01-10.7 16.01-16.01V72c0-13.23 10.78-24 23.1-24c13.22 0 24 10.77 24 24v130.7c0 6.938 5.451 16.01 16.03 16.01C219.5 218.7 220.1 208 237.7 208h13.72c21.5 0 18.56 19.21 34.7 19.21c8.063 0 9.805-5.487 20.15-5.487h13.72c26.96 0 17.37 27.43 40.77 27.43l14.07-.0037c13.88 0 25.16 11.28 25.16 25.14V384.2zM336 288C327.2 288 320 295.2 320 304v96c0 8.836 7.164 16 16 16s16-7.164 16-16v-96C352 295.2 344.8 288 336 288z"],
    "hand-scissors": [512, 512, [], "f257", "M270.1 480h97.92C447.4 480 512 417.1 512 339.7V231.8c0-23.45-6.106-46.73-17.66-67.33l-31.35-55.85C447.5 81.1 417.1 64 385.9 64h-46.97c-26.63 0-51.56 11.63-68.4 31.93l-15.46 18.71L127.3 68.44C119 65.46 110.5 64.05 102.1 64.05c-30.02 0-58.37 18.06-69.41 47.09C15.06 156.8 46.19 194 76.75 204.9l2.146 .7637L68.79 206.4C30.21 209 0 241.2 0 279.3c0 39.7 33.27 72.09 73.92 72.09c1.745 0 3.501-.0605 5.268-.1833l88.79-6.135v8.141c0 22.11 10.55 43.11 28.05 56.74C197.4 448.8 230.2 480 270.1 480zM269.1 432c-14.34 0-26-11.03-26-24.62c0 0 .0403-14.31 .0403-14.71c0-6.894-4.102-14.2-10.67-16.39c-10.39-3.5-17.38-12.78-17.38-23.06v-13.53c0-16.98 13.7-16.4 13.7-29.89c0-9.083-7.392-15.96-15.96-15.96c-.3646 0-.7311 .0125-1.099 .0377c0 0-138.1 9.505-138.7 9.505c-14.32 0-25.93-11.04-25.93-24.49c0-13.28 10.7-23.74 24.1-24.64l163.2-11.28c2.674-.1882 14.92-2.907 14.92-16.18c0-6.675-4.284-12.58-10.65-14.85L92.84 159.7C85.39 156.1 75.97 149.4 75.97 136.7c0-11.14 9.249-24.66 25.97-24.66c3.043 0 6.141 .5115 9.166 1.59l234.1 85.03c1.801 .6581 3.644 .9701 5.456 .9701c8.96 0 16-7.376 16-15.1c0-6.514-4.068-12.69-10.59-15.04l-64.81-23.47l15.34-18.56C315.2 117.3 326.6 112 338.9 112h46.97c14.77 0 28.28 7.719 35.27 20.16L452.5 188c7.531 13.41 11.52 28.56 11.52 43.81v107.9c0 50.91-43.06 92.31-96 92.31H269.1z"],
    "hand-spock": [576, 512, [128406], "f259", "M234.9 48.02c10.43 0 20.72 5.834 24.13 19.17l47.33 184.1c2.142 8.456 9.174 12.62 16.21 12.62c7.326 0 14.66-4.505 16.51-13.37l31.72-155.1c2.921-14.09 13.76-20.57 24.67-20.57c13.01 0 26.14 9.19 26.14 25.62c0 2.19-.2333 4.508-.7313 6.951l-28.48 139.2c-.2389 1.156-.3514 2.265-.3514 3.323c0 8.644 7.504 13.9 14.86 13.9c5.869 0 11.65-3.341 13.46-10.98l24.73-104.2c.2347-.9802 4.12-19.76 24.28-19.76c13.21 0 26.64 9.4 26.64 24.79c0 2.168-.2665 4.455-.8378 6.852l-48.06 204.7c-13.59 57.85-65.15 98.74-124.5 98.74l-48.79-.0234c-40.7-.0196-79.86-15.58-109.5-43.51l-75.93-71.55c-5.938-5.584-8.419-11.1-8.419-18.2c0-13.88 12.45-26.69 26.38-26.69c5.756 0 11.76 2.182 17.26 7.376l51.08 48.14c1.682 1.569 3.599 2.249 5.448 2.249c4.192 0 8.04-3.49 8.04-8.001c0-23.76-3.372-47.39-10.12-70.28L142 161.1C141.2 159.1 140.8 156.3 140.8 153.7c0-15.23 13.48-24.82 26.75-24.82c10.11 0 20.1 5.559 23.94 18.42l31.22 105.8c2.231 7.546 8.029 10.8 13.9 10.8c7.752 0 15.64-5.659 15.64-14.57c0-1.339-.1783-2.752-.562-4.23L209.3 80.06C208.7 77.45 208.3 74.97 208.3 72.62C208.3 57.33 221.7 48.02 234.9 48.02zM234.9 0C201.5 0 160.4 25.24 160.4 72.72c0 2.807 .1579 5.632 .4761 8.463C129.9 83.9 92.84 108.9 92.84 153.8c0 7.175 1.038 14.47 3.148 21.68l24.33 81.94C115.8 256.5 111.1 256 106.4 256C65.74 256 32 290.6 32 330.8c0 19.59 8.162 38.58 23.6 53.1l75.89 71.51c38.68 36.45 89.23 56.53 142.3 56.56L322.6 512c82.1 0 152.5-55.83 171.3-135.8l48.06-204.7C543.3 165.7 544 159.7 544 153.9c0-54.55-49.55-72.95-74.59-72.95c-.7689 0-1.534 .0117-2.297 .0352c-10.49-39.43-46.46-54.11-71.62-54.11c-34.1 0-64.45 24.19-71.63 58.83L319.2 108.5l-13.7-53.29C297.1 22.22 268.7 0 234.9 0z"],
    "handshake": [640, 512, [], "f2b5", "M506.1 127.1c-17.97-20.17-61.46-61.65-122.7-71.1c-22.5-3.354-45.39 3.606-63.41 18.21C302 60.47 279.1 53.42 256.5 56.86C176.8 69.17 126.7 136.2 124.6 139.1c-7.844 10.69-5.531 25.72 5.125 33.57c4.281 3.157 9.281 4.657 14.19 4.657c7.406 0 14.69-3.375 19.38-9.782c.4062-.5626 40.19-53.91 100.5-63.23c7.457-.9611 14.98 .67 21.56 4.483L227.2 168.2C214.8 180.5 207.1 196.1 207.1 214.5c0 17.5 6.812 33.94 19.16 46.29C239.5 273.2 255.9 279.1 273.4 279.1s33.94-6.813 46.31-19.19l11.35-11.35l124.2 100.9c2.312 1.875 2.656 5.251 .5 7.97l-27.69 35.75c-1.844 2.25-5.25 2.594-7.156 1.063l-22.22-18.69l-26.19 27.75c-2.344 2.875-5.344 3.563-6.906 3.719c-1.656 .1562-4.562 .125-6.812-1.719l-32.41-27.66L310.7 392.3l-2.812 2.938c-5.844 7.157-14.09 11.66-23.28 12.6c-9.469 .8126-18.25-1.75-24.5-6.782L170.3 319.8H96V128.3L0 128.3v255.6l64 .0404c11.74 0 21.57-6.706 27.14-16.14h60.64l77.06 69.66C243.7 449.6 261.9 456 280.8 456c2.875 0 5.781-.125 8.656-.4376c13.62-1.406 26.41-6.063 37.47-13.5l.9062 .8126c12.03 9.876 27.28 14.41 42.69 12.78c13.19-1.375 25.28-7.032 33.91-15.35c21.09 8.188 46.09 2.344 61.25-16.47l27.69-35.75c18.47-22.82 14.97-56.48-7.844-75.01l-120.3-97.76l8.381-8.382c9.375-9.376 9.375-24.57 0-33.94c-9.375-9.376-24.56-9.376-33.94 0L285.8 226.8C279.2 233.5 267.7 233.5 261.1 226.8c-3.312-3.282-5.125-7.657-5.125-12.31c0-4.688 1.812-9.064 5.281-12.53l85.91-87.64c7.812-7.845 18.53-11.75 28.94-10.03c59.75 9.22 100.2 62.73 100.6 63.29c3.088 4.155 7.264 6.946 11.84 8.376H544v175.1c0 17.67 14.33 32.05 31.1 32.05L640 384V128.1L506.1 127.1zM48 352c-8.75 0-16-7.245-16-15.99c0-8.876 7.25-15.99 16-15.99S64 327.2 64 336.1C64 344.8 56.75 352 48 352zM592 352c-8.75 0-16-7.245-16-15.99c0-8.876 7.25-15.99 16-15.99s16 7.117 16 15.99C608 344.8 600.8 352 592 352z"],
    "hard-drive": [512, 512, [128436, "hdd"], "f0a0", "M304 344c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C328 354.7 317.3 344 304 344zM448 32h-384c-35.35 0-64 28.65-64 64v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM464 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16v-96c0-8.822 7.178-16 16-16h384C456.8 304 464 311.2 464 320V416zM464 258.3C458.9 256.9 453.6 256 448 256H64C58.44 256 53.14 256.9 48 258.3V96c0-8.822 7.178-16 16-16h384c8.822 0 16 7.178 16 16V258.3zM400 344c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C424 354.7 413.3 344 400 344z"],
    "heart": [512, 512, [128153, 128154, 128155, 128156, 128420, 129293, 129294, 129505, 10084, 61578, 9829], "f004", "M462.1 62.86C438.8 41.92 408.9 31.1 378.7 32c-37.49 0-75.33 15.4-103 43.98l-19.7 20.27l-19.7-20.27C208.6 47.4 170.8 32 133.3 32C103.1 32 73.23 41.93 49.04 62.86c-62.14 53.79-65.25 149.7-9.23 207.6l193.2 199.7C239.4 476.7 247.6 480 255.9 480c8.332 0 16.69-3.267 23.01-9.804l193.1-199.7C528.2 212.5 525.1 116.6 462.1 62.86zM437.6 237.1l-181.6 187.8L74.34 237.1C42.1 203.8 34.46 138.1 80.46 99.15c39.9-34.54 94.59-17.5 121.4 10.17l54.17 55.92l54.16-55.92c26.42-27.27 81.26-44.89 121.4-10.17C477.1 138.6 470.5 203.1 437.6 237.1z"],
    "hospital": [384, 512, [127973], "f0f8", "M256 177.3V142.7c0-4.594-3.727-8.32-8.32-8.32h-30.08V104.3C217.6 99.73 213.9 96 209.3 96H174.7C170.1 96 166.4 99.73 166.4 104.3v30.08H136.3C131.7 134.4 128 138.1 128 142.7v34.56c0 4.594 3.727 8.32 8.32 8.32h30.08v30.08C166.4 220.3 170.1 224 174.7 224h34.56c4.594 0 8.32-3.727 8.32-8.32V185.6h30.08C252.3 185.6 256 181.9 256 177.3zM148 288h-40C101.4 288 96 293.4 96 300v40C96 346.6 101.4 352 108 352h40C154.6 352 160 346.6 160 340v-40C160 293.4 154.6 288 148 288zM148 384h-40C101.4 384 96 389.4 96 396v40C96 442.6 101.4 448 108 448h40C154.6 448 160 442.6 160 436v-40C160 389.4 154.6 384 148 384zM320 0H64C28.65 0 0 28.65 0 64v424C0 501.3 10.75 512 24 512s24-10.75 24-24V64c0-8.838 7.164-16 16-16h256c8.836 0 16 7.162 16 16v424c0 13.25 10.75 24 24 24S384 501.3 384 488V64C384 28.65 355.3 0 320 0zM276 288h-40C229.4 288 224 293.4 224 300v40C224 346.6 229.4 352 236 352h40C282.6 352 288 346.6 288 340v-40C288 293.4 282.6 288 276 288zM276 384h-40C229.4 384 224 389.4 224 396v40C224 442.6 229.4 448 236 448h40C282.6 448 288 442.6 288 436v-40C288 389.4 282.6 384 276 384z"],
    "hourglass": [384, 512, [62032, 9203, "hourglass-2", "hourglass-half"], "f254", "M0 24C0 10.75 10.75 0 24 0H360C373.3 0 384 10.75 384 24C384 37.25 373.3 48 360 48H352V66.98C352 107.3 335.1 145.1 307.5 174.5L225.9 256L307.5 337.5C335.1 366 352 404.7 352 445V464H360C373.3 464 384 474.7 384 488C384 501.3 373.3 512 360 512H24C10.75 512 0 501.3 0 488C0 474.7 10.75 464 24 464H32V445C32 404.7 48.01 366 76.52 337.5L158.1 256L76.52 174.5C48.01 145.1 32 107.3 32 66.98V48H24C10.75 48 0 37.25 0 24V24zM99.78 384H284.2C281 379.6 277.4 375.4 273.5 371.5L192 289.9L110.5 371.5C106.6 375.4 102.1 379.6 99.78 384H99.78zM284.2 128C296.1 110.4 304 89.03 304 66.98V48H80V66.98C80 89.03 87 110.4 99.78 128H284.2z"],
    "id-badge": [384, 512, [], "f2c1", "M320 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h256c35.35 0 64-28.65 64-64V64C384 28.65 355.3 0 320 0zM336 448c0 8.836-7.164 16-16 16H64c-8.836 0-16-7.164-16-16V64c0-8.838 7.164-16 16-16h64V64c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V48h64c8.836 0 16 7.162 16 16V448zM192 288c35.35 0 64-28.65 64-64s-28.65-64-64-64C156.7 160 128 188.7 128 224S156.7 288 192 288zM224 320H160c-44.18 0-80 35.82-80 80C80 408.8 87.16 416 96 416h192c8.836 0 16-7.164 16-16C304 355.8 268.2 320 224 320z"],
    "id-card": [576, 512, [62147, "drivers-license"], "f2c2", "M368 344h96c13.25 0 24-10.75 24-24s-10.75-24-24-24h-96c-13.25 0-24 10.75-24 24S354.8 344 368 344zM208 320c35.35 0 64-28.65 64-64c0-35.35-28.65-64-64-64s-64 28.65-64 64C144 291.3 172.7 320 208 320zM512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM528 416c0 8.822-7.178 16-16 16h-192c0-44.18-35.82-80-80-80h-64C131.8 352 96 387.8 96 432H64c-8.822 0-16-7.178-16-16V160h480V416zM368 264h96c13.25 0 24-10.75 24-24s-10.75-24-24-24h-96c-13.25 0-24 10.75-24 24S354.8 264 368 264z"],
    "image": [512, 512, [], "f03e", "M152 120c-26.51 0-48 21.49-48 48s21.49 48 48 48s48-21.49 48-48S178.5 120 152 120zM447.1 32h-384C28.65 32-.0091 60.65-.0091 96v320c0 35.35 28.65 64 63.1 64h384c35.35 0 64-28.65 64-64V96C511.1 60.65 483.3 32 447.1 32zM463.1 409.3l-136.8-185.9C323.8 218.8 318.1 216 312 216c-6.113 0-11.82 2.768-15.21 7.379l-106.6 144.1l-37.09-46.1c-3.441-4.279-8.934-6.809-14.77-6.809c-5.842 0-11.33 2.529-14.78 6.809l-75.52 93.81c0-.0293 0 .0293 0 0L47.99 96c0-8.822 7.178-16 16-16h384c8.822 0 16 7.178 16 16V409.3z"],
    "images": [576, 512, [], "f302", "M512 32H160c-35.35 0-64 28.65-64 64v224c0 35.35 28.65 64 64 64H512c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM528 320c0 8.822-7.178 16-16 16h-16l-109.3-160.9C383.7 170.7 378.7 168 373.3 168c-5.352 0-10.35 2.672-13.31 7.125l-62.74 94.11L274.9 238.6C271.9 234.4 267.1 232 262 232c-5.109 0-9.914 2.441-12.93 6.574L176 336H160c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16H512c8.822 0 16 7.178 16 16V320zM224 112c-17.67 0-32 14.33-32 32s14.33 32 32 32c17.68 0 32-14.33 32-32S241.7 112 224 112zM456 480H120C53.83 480 0 426.2 0 360v-240C0 106.8 10.75 96 24 96S48 106.8 48 120v240c0 39.7 32.3 72 72 72h336c13.25 0 24 10.75 24 24S469.3 480 456 480z"],
    "keyboard": [576, 512, [9000], "f11c", "M512 64H64C28.65 64 0 92.65 0 128v256c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V128C576 92.65 547.3 64 512 64zM528 384c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V128c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V384zM140 152h-24c-6.656 0-12 5.344-12 12v24c0 6.656 5.344 12 12 12h24c6.656 0 12-5.344 12-12v-24C152 157.3 146.7 152 140 152zM196 200h24c6.656 0 12-5.344 12-12v-24c0-6.656-5.344-12-12-12h-24c-6.656 0-12 5.344-12 12v24C184 194.7 189.3 200 196 200zM276 200h24c6.656 0 12-5.344 12-12v-24c0-6.656-5.344-12-12-12h-24c-6.656 0-12 5.344-12 12v24C264 194.7 269.3 200 276 200zM356 200h24c6.656 0 12-5.344 12-12v-24c0-6.656-5.344-12-12-12h-24c-6.656 0-12 5.344-12 12v24C344 194.7 349.3 200 356 200zM460 152h-24c-6.656 0-12 5.344-12 12v24c0 6.656 5.344 12 12 12h24c6.656 0 12-5.344 12-12v-24C472 157.3 466.7 152 460 152zM140 232h-24c-6.656 0-12 5.344-12 12v24c0 6.656 5.344 12 12 12h24c6.656 0 12-5.344 12-12v-24C152 237.3 146.7 232 140 232zM196 280h24c6.656 0 12-5.344 12-12v-24c0-6.656-5.344-12-12-12h-24c-6.656 0-12 5.344-12 12v24C184 274.7 189.3 280 196 280zM276 280h24c6.656 0 12-5.344 12-12v-24c0-6.656-5.344-12-12-12h-24c-6.656 0-12 5.344-12 12v24C264 274.7 269.3 280 276 280zM356 280h24c6.656 0 12-5.344 12-12v-24c0-6.656-5.344-12-12-12h-24c-6.656 0-12 5.344-12 12v24C344 274.7 349.3 280 356 280zM460 232h-24c-6.656 0-12 5.344-12 12v24c0 6.656 5.344 12 12 12h24c6.656 0 12-5.344 12-12v-24C472 237.3 466.7 232 460 232zM400 320h-224C167.1 320 160 327.1 160 336V352c0 8.875 7.125 16 16 16h224c8.875 0 16-7.125 16-16v-16C416 327.1 408.9 320 400 320z"],
    "lemon": [448, 512, [127819], "f094", "M439.9 144.6c15.34-26.38 8.372-62.41-16.96-87.62c-25.21-25.32-61.22-32.26-87.61-16.95c-9.044 5.218-27.15 3.702-48.08 1.968c-50.78-4.327-127.4-10.73-207.6 69.56C-.6501 191.9 5.801 268.5 10.07 319.3c1.749 20.96 3.28 39.07-1.984 48.08c-15.35 26.4-8.357 62.45 16.92 87.57c16.26 16.37 37.05 25.09 56.83 25.09c10.89 0 21.46-2.64 30.83-8.092c9.013-5.249 27.12-3.718 48.08-1.968c50.69 4.233 127.4 10.7 207.6-69.56c80.27-80.28 73.82-156.9 69.56-207.7C436.2 171.8 434.7 153.7 439.9 144.6zM398.4 120.5c-12.87 22.09-10.67 48.41-8.326 76.25c4.155 49.3 8.841 105.2-55.67 169.7c-64.53 64.49-120.5 59.78-169.7 55.68c-27.85-2.328-54.12-4.53-76.26 8.311c-6.139 3.64-19.17 1.031-29.58-9.451c-10.39-10.33-12.95-23.35-9.372-29.49c12.87-22.09 10.67-48.41 8.326-76.25C53.72 265.1 49.04 210.1 113.5 145.5c48.27-48.27 91.71-57.8 131.2-57.8c13.28 0 26.12 1.078 38.52 2.125c27.9 2.359 54.17 4.561 76.26-8.311c6.123-3.577 19.18-1.031 29.49 9.357C399.4 101.2 402 114.4 398.4 120.5zM239.5 124.1c2.156 8.561-3.062 17.25-11.62 19.43C183.6 154.7 122.7 215.6 111.6 259.9C109.7 267.1 103.2 271.1 96.05 271.1c-1.281 0-2.593-.1562-3.905-.4687C83.58 269.3 78.4 260.6 80.52 252.1C94.67 195.8 163.8 126.7 220.1 112.5C228.8 110.4 237.3 115.5 239.5 124.1z"],
    "life-ring": [512, 512, [], "f1cd", "M453.2 419.2C489.9 374.9 512 318.1 512 256s-22.09-118.9-58.82-163.2l11.79-11.79c9.375-9.375 9.375-24.56 0-33.94s-24.56-9.375-33.94 0l-11.79 11.79C374.9 22.09 318.1 0 256 0S137.1 22.09 92.76 58.82L80.97 47.03c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l11.79 11.79C22.09 137.1 0 193.9 0 256s22.09 118.9 58.82 163.2l-11.79 11.79c-9.375 9.375-9.375 24.56 0 33.94C51.72 469.7 57.86 472 64 472s12.28-2.344 16.97-7.031l11.79-11.79C137.1 489.9 193.9 512 256 512s118.9-22.09 163.2-58.82l11.79 11.79C435.7 469.7 441.9 472 448 472s12.28-2.344 16.97-7.031c9.375-9.375 9.375-24.56 0-33.94L453.2 419.2zM464 256c0 48.71-16.95 93.47-45.11 128.1l-80.47-80.47C346.8 290.2 352 273.8 352 256s-5.16-34.21-13.58-48.48l80.47-80.47C447 162.5 464 207.3 464 256zM208 256c0-26.47 21.53-48 48-48s48 21.53 48 48S282.5 304 256 304S208 282.5 208 256zM256 48c48.71 0 93.47 16.95 128.1 45.11l-80.47 80.47C290.2 165.2 273.8 160 256 160S221.8 165.2 207.5 173.6L127 93.11C162.5 64.95 207.3 48 256 48zM48 256c0-48.71 16.95-93.47 45.11-128.1l80.47 80.47C165.2 221.8 160 238.2 160 256s5.16 34.21 13.58 48.48l-80.47 80.47C64.95 349.5 48 304.7 48 256zM256 464c-48.71 0-93.47-16.95-128.1-45.11l80.47-80.47C221.8 346.8 238.2 352 256 352s34.21-5.16 48.48-13.58l80.47 80.47C349.5 447 304.7 464 256 464z"],
    "lightbulb": [384, 512, [128161], "f0eb", "M112.1 454.3c0 6.297 1.816 12.44 5.284 17.69l17.14 25.69c5.25 7.875 17.17 14.28 26.64 14.28h61.67c9.438 0 21.36-6.401 26.61-14.28l17.08-25.68c2.938-4.438 5.348-12.37 5.348-17.7L272 415.1h-160L112.1 454.3zM192 0C90.02 .3203 16 82.97 16 175.1c0 44.38 16.44 84.84 43.56 115.8c16.53 18.84 42.34 58.23 52.22 91.45c.0313 .25 .0938 .5166 .125 .7823h160.2c.0313-.2656 .0938-.5166 .125-.7823c9.875-33.22 35.69-72.61 52.22-91.45C351.6 260.8 368 220.4 368 175.1C368 78.8 289.2 .0039 192 0zM288.4 260.1c-15.66 17.85-35.04 46.3-49.05 75.89h-94.61c-14.01-29.59-33.39-58.04-49.04-75.88C75.24 236.8 64 206.1 64 175.1C64 113.3 112.1 48.25 191.1 48C262.6 48 320 105.4 320 175.1C320 206.1 308.8 236.8 288.4 260.1zM176 80C131.9 80 96 115.9 96 160c0 8.844 7.156 16 16 16S128 168.8 128 160c0-26.47 21.53-48 48-48c8.844 0 16-7.148 16-15.99S184.8 80 176 80z"],
    "map": [576, 512, [62072, 128506], "f279", "M554 33.15L384 95.1L212 35.25c-6.5-2.125-13.19-3.249-20.06-3.249c-6.625 0-13.56 .9995-19.94 3.124L20.12 87.1C8 92.75 0 104.6 0 117.6v346.4c0 10.89 10.85 19.02 22 14.84L192 415.1l172 60.75c13 4.25 27 4.375 40 .125l151.9-52.88C568 419.2 576 407.4 576 394.4V48.01C576 37.12 565.2 28.96 554 33.15zM224 90.37l128 45.25v286l-128-45.25V90.37zM48 417.1V129.1l128-44.62v286.3L48 417.1zM528 382.9l-128 44.63V141.2l128-47.25V382.9z"],
    "message": [512, 512, ["comment-alt"], "f27a", "M447.1 0h-384c-35.25 0-64 28.75-64 63.1v287.1c0 35.25 28.75 63.1 64 63.1h96v83.98c0 9.836 11.02 15.55 19.12 9.7l124.9-93.68h144c35.25 0 64-28.75 64-63.1V63.1C511.1 28.75 483.2 0 447.1 0zM464 352c0 8.75-7.25 16-16 16h-160l-80 60v-60H64c-8.75 0-16-7.25-16-16V64c0-8.75 7.25-16 16-16h384c8.75 0 16 7.25 16 16V352z"],
    "money-bill-1": [576, 512, ["money-bill-alt"], "f3d1", "M336 300.4v23.11C336 330.4 330.4 336 323.6 336H252.4C245.6 336 240 330.4 240 323.6V300.4C240 293.6 245.6 288 252.4 288H264V224H252.4c-4.273 0-8.359-2.332-10.5-5.832C239.6 214.5 239.4 209.8 241.3 205.9l12.44-23.11C255.9 178.7 259.3 176 264 176h35.55C306.4 176 312 181.6 312 188.4V288h11.55C330.4 288 336 293.6 336 300.4zM576 128v256c0 35.35-28.65 64-64 64H64c-35.35 0-64-28.65-64-64V128c0-35.35 28.65-64 64-64h448C547.3 64 576 92.65 576 128zM528 176c-35.38 0-64-28.62-64-64h-352c0 35.38-28.62 64-64 64v160c35.38 0 64 28.62 64 64h352c0-35.38 28.62-64 64-64V176z"],
    "moon": [512, 512, [127769, 9214], "f186", "M421.6 379.9c-.6641 0-1.35 .0625-2.049 .1953c-11.24 2.143-22.37 3.17-33.32 3.17c-94.81 0-174.1-77.14-174.1-175.5c0-63.19 33.79-121.3 88.73-152.6c8.467-4.812 6.339-17.66-3.279-19.44c-11.2-2.078-29.53-3.746-40.9-3.746C132.3 31.1 32 132.2 32 256c0 123.6 100.1 224 223.8 224c69.04 0 132.1-31.45 173.8-82.93C435.3 389.1 429.1 379.9 421.6 379.9zM255.8 432C158.9 432 80 353 80 256c0-76.32 48.77-141.4 116.7-165.8C175.2 125 163.2 165.6 163.2 207.8c0 99.44 65.13 183.9 154.9 212.8C298.5 428.1 277.4 432 255.8 432z"],
    "newspaper": [512, 512, [128240], "f1ea", "M456 32h-304C121.1 32 96 57.13 96 88v320c0 13.22-10.77 24-24 24S48 421.2 48 408V112c0-13.25-10.75-24-24-24S0 98.75 0 112v296C0 447.7 32.3 480 72 480h352c48.53 0 88-39.47 88-88v-304C512 57.13 486.9 32 456 32zM464 392c0 22.06-17.94 40-40 40H139.9C142.5 424.5 144 416.4 144 408v-320c0-4.406 3.594-8 8-8h304c4.406 0 8 3.594 8 8V392zM264 272h-64C186.8 272 176 282.8 176 296S186.8 320 200 320h64C277.3 320 288 309.3 288 296S277.3 272 264 272zM408 272h-64C330.8 272 320 282.8 320 296S330.8 320 344 320h64c13.25 0 24-10.75 24-24S421.3 272 408 272zM264 352h-64c-13.25 0-24 10.75-24 24s10.75 24 24 24h64c13.25 0 24-10.75 24-24S277.3 352 264 352zM408 352h-64C330.8 352 320 362.8 320 376s10.75 24 24 24h64c13.25 0 24-10.75 24-24S421.3 352 408 352zM400 112h-192c-17.67 0-32 14.33-32 32v64c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32v-64C432 126.3 417.7 112 400 112z"],
    "note-sticky": [448, 512, [62026, "sticky-note"], "f249", "M384 32H64.01C28.66 32 .0085 60.65 .0065 96L0 415.1C-.002 451.3 28.65 480 64 480h232.1c25.46 0 49.88-10.12 67.89-28.12l55.88-55.89C437.9 377.1 448 353.6 448 328.1V96C448 60.8 419.2 32 384 32zM52.69 427.3C50.94 425.6 48 421.8 48 416l.0195-319.1C48.02 87.18 55.2 80 64.02 80H384c8.674 0 16 7.328 16 16v192h-88C281.1 288 256 313.1 256 344v88H64C58.23 432 54.44 429.1 52.69 427.3zM330.1 417.9C322.9 425.1 313.8 429.6 304 431.2V344c0-4.406 3.594-8 8-8h87.23c-1.617 9.812-6.115 18.88-13.29 26.05L330.1 417.9z"],
    "object-group": [512, 512, [], "f247", "M512 112V64c0-17.67-14.33-32-32-32h-48c-17.67 0-32 14.33-32 32h-288c0-17.67-14.33-32-32-32H32C14.33 32 0 46.33 0 64v48c0 17.67 14.33 32 32 32v224c-17.67 0-32 14.33-32 32V448c0 17.67 14.33 32 32 32h48c17.67 0 32-14.33 32-32h288c0 17.67 14.33 32 32 32H480c17.67 0 32-14.33 32-32v-48c0-17.67-14.33-32-32-32v-224C497.7 144 512 129.7 512 112zM72 440h-32v-32h32V440zM72 104h-32v-32h32V104zM432 368c-17.67 0-32 14.33-32 32h-288c0-17.67-14.33-32-32-32v-224c17.67 0 32-14.33 32-32h288c0 17.67 14.33 32 32 32V368zM472 440h-32v-32h32V440zM472 104h-32v-32h32V104zM288 256V176c0-17.67-14.33-32-32-32H144c-17.67 0-32 14.33-32 32V256c0 17.67 14.33 32 32 32H256C273.7 288 288 273.7 288 256zM248 248h-96v-64h96V248zM368 224H320v40h40v64h-96V320H224v16c0 17.67 14.33 32 32 32h112c17.67 0 32-14.33 32-32V256C400 238.3 385.7 224 368 224z"],
    "object-ungroup": [640, 512, [], "f248", "M640 240V192c0-17.67-14.33-32-32-32h-48c-17.67 0-32 14.33-32 32h-64v48h64c0 17.67 14.33 32 32 32v128c-17.67 0-32 14.33-32 32h-224c0-17.67-14.33-32-32-32V352H224v48c-17.67 0-32 14.33-32 32V480c0 17.67 14.33 32 32 32h48c17.67 0 32-14.33 32-32h224c0 17.67 14.33 32 32 32H608c17.67 0 32-14.33 32-32v-48c0-17.67-14.33-32-32-32v-128C625.7 272 640 257.7 640 240zM264 472h-32v-32h32V472zM600 472h-32v-32h32V472zM600 232h-32v-32h32V232zM368 352H416c17.67 0 32-14.33 32-32V272c0-17.67-14.33-32-32-32v-128c17.67 0 32-14.33 32-32V32c0-17.67-14.33-32-32-32h-48c-17.67 0-32 14.33-32 32h-224c0-17.67-14.33-32-32-32H32C14.33 0 0 14.33 0 32v48c0 17.67 14.33 32 32 32v128c-17.67 0-32 14.33-32 32V320c0 17.67 14.33 32 32 32h48c17.67 0 32-14.33 32-32h224C336 337.7 350.3 352 368 352zM376 40h32v32h-32V40zM376 280h32v32h-32V280zM72 312h-32v-32h32V312zM72 72h-32v-32h32V72zM80 240v-128c17.67 0 32-14.33 32-32h224c0 17.67 14.33 32 32 32v128c-17.67 0-32 14.33-32 32h-224C112 254.3 97.67 240 80 240z"],
    "paper-plane": [512, 512, [61913], "f1d8", "M501.6 4.186c-7.594-5.156-17.41-5.594-25.44-1.063L12.12 267.1C4.184 271.7-.5037 280.3 .0431 289.4c.5469 9.125 6.234 17.16 14.66 20.69l153.3 64.38v113.5c0 8.781 4.797 16.84 12.5 21.06C184.1 511 188 512 191.1 512c4.516 0 9.038-1.281 12.99-3.812l111.2-71.46l98.56 41.4c2.984 1.25 6.141 1.875 9.297 1.875c4.078 0 8.141-1.031 11.78-3.094c6.453-3.625 10.88-10.06 11.95-17.38l64-432C513.1 18.44 509.1 9.373 501.6 4.186zM369.3 119.2l-187.1 208.9L78.23 284.7L369.3 119.2zM215.1 444v-49.36l46.45 19.51L215.1 444zM404.8 421.9l-176.6-74.19l224.6-249.5L404.8 421.9z"],
    "pen-to-square": [512, 512, ["edit"], "f044", "M495.6 49.23l-32.82-32.82C451.8 5.471 437.5 0 423.1 0c-14.33 0-28.66 5.469-39.6 16.41L167.5 232.5C159.1 240 154.8 249.5 152.4 259.8L128.3 367.2C126.5 376.1 133.4 384 141.1 384c.916 0 1.852-.0918 2.797-.2813c0 0 74.03-15.71 107.4-23.56c10.1-2.377 19.13-7.459 26.46-14.79l217-217C517.5 106.5 517.4 71.1 495.6 49.23zM461.7 94.4L244.7 311.4C243.6 312.5 242.5 313.1 241.2 313.4c-13.7 3.227-34.65 7.857-54.3 12.14l12.41-55.2C199.6 268.9 200.3 267.5 201.4 266.5l216.1-216.1C419.4 48.41 421.6 48 423.1 48s3.715 .4062 5.65 2.342l32.82 32.83C464.8 86.34 464.8 91.27 461.7 94.4zM424 288c-13.25 0-24 10.75-24 24v128c0 13.23-10.78 24-24 24h-304c-13.22 0-24-10.77-24-24v-304c0-13.23 10.78-24 24-24h144c13.25 0 24-10.75 24-24S229.3 64 216 64L71.1 63.99C32.31 63.99 0 96.29 0 135.1v304C0 479.7 32.31 512 71.1 512h303.1c39.69 0 71.1-32.3 71.1-72L448 312C448 298.8 437.3 288 424 288z"],
    "rectangle-list": [576, 512, ["list-alt"], "f022", "M512 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V96C576 60.65 547.3 32 512 32zM528 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16h448c8.822 0 16 7.178 16 16V416zM128 128C110.3 128 96 142.3 96 160c0 17.67 14.33 32 32 32s32-14.33 32-32C160 142.3 145.7 128 128 128zM128 224C110.3 224 96 238.3 96 256c0 17.67 14.33 32 32 32s32-14.33 32-32C160 238.3 145.7 224 128 224zM128 320c-17.67 0-32 14.33-32 32c0 17.67 14.33 32 32 32s32-14.33 32-32C160 334.3 145.7 320 128 320zM456 136H215.1C202.7 136 192 146.8 192 160S202.7 184 215.1 184H456c13.25 0 24-10.75 24-24S469.3 136 456 136zM456 232H215.1C202.7 232 192 242.8 192 256c0 13.25 10.75 24 23.1 24H456c13.25 0 24-10.75 24-24C480 242.7 469.3 232 456 232zM456 328H215.1C202.7 328 192 338.8 192 352s10.75 24 23.1 24H456c13.25 0 24-10.75 24-24S469.3 328 456 328z"],
    "rectangle-xmark": [512, 512, [62164, "rectangle-times", "times-rectangle", "window-close"], "f410", "M448 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64V96C512 60.65 483.3 32 448 32zM464 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16h384c8.822 0 16 7.178 16 16V416zM336.1 175c-9.375-9.375-24.56-9.375-33.94 0L256 222.1L208.1 175c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l47.03 47.03L175 303c-9.375 9.375-9.375 24.56 0 33.94c9.373 9.373 24.56 9.381 33.94 0L256 289.9l47.03 47.03c9.373 9.373 24.56 9.381 33.94 0c9.375-9.375 9.375-24.56 0-33.94l-47.03-47.03l47.03-47.03C346.3 199.6 346.3 184.4 336.1 175z"],
    "registered": [512, 512, [174], "f25d", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 464c-114.7 0-208-93.31-208-208S141.3 48 256 48s208 93.31 208 208S370.7 464 256 464zM352 208c0-44.13-35.88-80-80-80L184 128c-13.25 0-24 10.75-24 24v208c0 13.25 10.75 24 24 24s24-10.75 24-24v-72h59.79l38.46 82.19C310.3 378.9 319 384 328 384c3.438 0 6.875-.7187 10.19-2.25c12-5.625 17.16-19.91 11.56-31.94l-34.87-74.5C337.1 261.1 352 236.3 352 208zM272 240h-64v-64h64c17.66 0 32 14.34 32 32S289.7 240 272 240z"],
    "share-from-square": [576, 512, [61509, "share-square"], "f14d", "M568.5 142.6l-144-135.1c-9.625-9.156-24.81-8.656-33.91 .9687c-9.125 9.625-8.688 24.81 .9687 33.91l100.1 94.56h-163.4C287.5 134.2 249.7 151 221 179.4C192 208.2 176 246.7 176 288v87.1c0 13.25 10.75 23.1 24 23.1S224 389.3 224 376V288c0-28.37 10.94-54.84 30.78-74.5C274.3 194.2 298.9 183 328 184h163.6l-100.1 94.56c-9.656 9.094-10.09 24.28-.9687 33.91c4.719 4.1 11.06 7.531 17.44 7.531c5.906 0 11.84-2.156 16.47-6.562l144-135.1C573.3 172.9 576 166.6 576 160S573.3 147.1 568.5 142.6zM360 384c-13.25 0-24 10.75-24 23.1v47.1c0 4.406-3.594 7.1-8 7.1h-272c-4.406 0-8-3.594-8-7.1V184c0-4.406 3.594-7.1 8-7.1H112c13.25 0 24-10.75 24-23.1s-10.75-23.1-24-23.1H56c-30.88 0-56 25.12-56 55.1v271.1C0 486.9 25.13 512 56 512h272c30.88 0 56-25.12 56-55.1v-47.1C384 394.8 373.3 384 360 384z"],
    "snowflake": [512, 512, [10054, 10052], "f2dc", "M484.4 294.4c1.715 6.402 .6758 12.89-2.395 18.21s-8.172 9.463-14.57 11.18l-31.46 8.43l32.96 19.03C480.4 357.8 484.4 372.5 477.8 384s-21.38 15.41-32.86 8.783l-32.96-19.03l8.43 31.46c3.432 12.81-4.162 25.96-16.97 29.39s-25.96-4.162-29.39-16.97l-20.85-77.82L280 297.6v84.49l56.97 56.97c9.375 9.375 9.375 24.56 0 33.94C332.3 477.7 326.1 480 320 480s-12.28-2.344-16.97-7.031L280 449.9V488c0 13.25-10.75 24-24 24s-24-10.75-24-24v-38.06l-23.03 23.03c-9.375 9.375-24.56 9.375-33.94 0s-9.375-24.56 0-33.94L232 382.1V297.6l-73.17 42.25l-20.85 77.82c-3.432 12.81-16.58 20.4-29.39 16.97s-20.4-16.58-16.97-29.39l8.43-31.46l-32.96 19.03C55.61 399.4 40.85 395.5 34.22 384s-2.615-26.16 8.859-32.79l32.96-19.03l-31.46-8.43c-12.81-3.432-20.4-16.58-16.97-29.39s16.58-20.4 29.39-16.97l77.82 20.85L208 255.1L134.8 213.8L57.01 234.6C44.2 238 31.05 230.4 27.62 217.6s4.162-25.96 16.97-29.39l31.46-8.432L43.08 160.8C31.61 154.2 27.6 139.5 34.22 128s21.38-15.41 32.86-8.785l32.96 19.03L91.62 106.8C88.18 93.98 95.78 80.83 108.6 77.39s25.96 4.162 29.39 16.97l20.85 77.82L232 214.4V129.9L175 72.97c-9.375-9.375-9.375-24.56 0-33.94s24.56-9.375 33.94 0L232 62.06V24C232 10.75 242.8 0 256 0s24 10.75 24 24v38.06l23.03-23.03c9.375-9.375 24.56-9.375 33.94 0s9.375 24.56 0 33.94L280 129.9v84.49l73.17-42.25l20.85-77.82c3.432-12.81 16.58-20.4 29.39-16.97c6.402 1.715 11.5 5.861 14.57 11.18s4.109 11.81 2.395 18.21l-8.43 31.46l32.96-19.03C456.4 112.6 471.2 116.5 477.8 128s2.615 26.16-8.859 32.78l-32.96 19.03l31.46 8.432c12.81 3.432 20.4 16.58 16.97 29.39s-16.58 20.4-29.39 16.97l-77.82-20.85L304 255.1l73.17 42.25l77.82-20.85C467.8 273.1 480.1 281.6 484.4 294.4z"],
    "square": [448, 512, [9723, 9724, 61590, 9632], "f0c8", "M384 31.1H64c-35.35 0-64 28.65-64 63.1v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64v-320C448 60.65 419.3 31.1 384 31.1zM400 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16h320c8.822 0 16 7.178 16 16V416z"],
    "square-caret-down": [448, 512, ["caret-square-down"], "f150", "M320 192H128C118.5 192 109.8 197.7 105.1 206.4C102.2 215.1 103.9 225.3 110.4 232.3l96 104C210.9 341.2 217.3 344 224 344s13.09-2.812 17.62-7.719l96-104c6.469-7 8.188-17.19 4.375-25.91C338.2 197.7 329.5 192 320 192zM384 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V96C448 60.66 419.3 32 384 32zM400 416c0 8.82-7.178 16-16 16H64c-8.822 0-16-7.18-16-16V96c0-8.82 7.178-16 16-16h320c8.822 0 16 7.18 16 16V416z"],
    "square-caret-left": [448, 512, ["caret-square-left"], "f191", "M384 32H64C28.66 32 0 60.66 0 96v320c0 35.34 28.66 64 64 64h320c35.34 0 64-28.66 64-64V96C448 60.66 419.3 32 384 32zM400 416c0 8.82-7.18 16-16 16H64c-8.82 0-16-7.18-16-16V96c0-8.82 7.18-16 16-16h320c8.82 0 16 7.18 16 16V416zM273.6 138c-8.719-3.812-18.91-2.094-25.91 4.375l-104 96C138.8 242.9 136 249.3 136 256s2.812 13.09 7.719 17.62l104 96c7 6.469 17.19 8.188 25.91 4.375C282.3 370.2 288 361.5 288 352V160C288 150.5 282.3 141.8 273.6 138z"],
    "square-caret-right": [448, 512, ["caret-square-right"], "f152", "M200.3 142.4C193.3 135.9 183.1 134.2 174.4 138C165.7 141.8 160 150.5 160 159.1v192C160 361.5 165.7 370.2 174.4 374c8.719 3.812 18.91 2.094 25.91-4.375l104-96C309.2 269.1 312 262.7 312 256s-2.812-13.09-7.719-17.62L200.3 142.4zM384 32H64C28.66 32 0 60.66 0 96v320c0 35.34 28.66 64 64 64h320c35.34 0 64-28.66 64-64V96C448 60.66 419.3 32 384 32zM400 416c0 8.82-7.18 16-16 16H64c-8.82 0-16-7.18-16-16V96c0-8.82 7.18-16 16-16h320c8.82 0 16 7.18 16 16V416z"],
    "square-caret-up": [448, 512, ["caret-square-up"], "f151", "M241.6 175.7C237.1 170.8 230.7 168 224 168S210.9 170.8 206.4 175.7l-96 104c-6.469 7-8.188 17.19-4.375 25.91C109.8 314.3 118.5 320 127.1 320h192c9.531 0 18.16-5.656 22-14.38c3.813-8.719 2.094-18.91-4.375-25.91L241.6 175.7zM384 32H64C28.65 32 0 60.66 0 96v320c0 35.34 28.65 64 64 64h320c35.35 0 64-28.66 64-64V96C448 60.66 419.3 32 384 32zM400 416c0 8.82-7.178 16-16 16H64c-8.822 0-16-7.18-16-16V96c0-8.82 7.178-16 16-16h320c8.822 0 16 7.18 16 16V416z"],
    "square-check": [448, 512, [9989, 61510, 9745, "check-square"], "f14a", "M384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96C448 60.65 419.3 32 384 32zM400 416c0 8.836-7.164 16-16 16H64c-8.836 0-16-7.164-16-16V96c0-8.838 7.164-16 16-16h320c8.836 0 16 7.162 16 16V416zM303 175L192 286.1L144.1 239c-9.375-9.375-24.56-9.375-33.94 0s-9.375 24.56 0 33.94l64 64C179.7 341.7 185.8 344 192 344s12.28-2.344 16.97-7.031l128-128c9.375-9.375 9.375-24.56 0-33.94S312.4 165.7 303 175z"],
    "square-full": [512, 512, [128997, 128998, 128999, 129000, 129001, 129002, 129003, 11036, 11035], "f45c", "M464 48v416h-416v-416H464zM512 0H0v512h512V0z"],
    "square-minus": [448, 512, [61767, "minus-square"], "f146", "M319.1 232h-192C114.7 232 103.1 242.7 103.1 256S114.7 280 127.1 280h192c13.25 0 23.1-10.75 23.1-24S333.3 232 319.1 232zM384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96C448 60.65 419.3 32 384 32zM400 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16h320c8.822 0 16 7.178 16 16V416z"],
    "square-plus": [448, 512, [61846, "plus-square"], "f0fe", "M319.1 232h-72V160c0-13.25-10.74-24-23.1-24S199.1 146.7 199.1 160v72H127.1C114.7 232 103.1 242.7 103.1 256S114.7 280 127.1 280h71.1V352c0 13.25 10.75 24 24 24s23.1-10.75 23.1-24V280h72c13.25 0 23.1-10.75 23.1-24S333.3 232 319.1 232zM384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96C448 60.65 419.3 32 384 32zM400 416c0 8.822-7.178 16-16 16H64c-8.822 0-16-7.178-16-16V96c0-8.822 7.178-16 16-16h320c8.822 0 16 7.178 16 16V416z"],
    "star": [576, 512, [61446, 11088], "f005", "M528.5 171.5l-146.4-21.29l-65.43-132.4C310.9 5.971 299.4-.002 287.1 0C276.6 0 265.1 5.899 259.3 17.8L193.8 150.2L47.47 171.5C21.2 175.3 10.68 207.6 29.72 226.1l105.9 102.1L110.6 474.6C107 495.3 123.6 512 142.2 512c4.932 0 10.01-1.172 14.88-3.75L288 439.6l130.9 68.7c4.865 2.553 9.926 3.713 14.85 3.713c18.61 0 35.21-16.61 31.65-37.41l-25.05-145.5l105.9-102.1C565.3 207.6 554.8 175.3 528.5 171.5zM390.2 320.6l22.4 130.1l-117.2-61.48c-4.655-2.442-10.21-2.442-14.87 .0001L163.4 450.7l22.4-130.1C186.7 315.4 184.1 310.1 181.2 306.4l-94.7-92.09l130.9-19.04C222.6 194.5 227.1 191.2 229.4 186.5L288 67.99l58.59 118.5c2.331 4.717 6.833 7.986 12.04 8.744l130.9 19.04l-94.7 92.09C391 310.1 389.3 315.4 390.2 320.6z"],
    "star-half": [576, 512, [61731], "f089", "M287.9 25.05C287.9 9.428 266.5 3.525 259.4 17.45c-.0599 .1179-65.61 132.7-65.61 132.7L47.47 171.5C21.2 175.3 10.68 207.6 29.72 226.1l105.9 102.1L110.6 474.6C107 495.3 123.6 512 142.2 512c4.932 0 10.01-1.172 14.88-3.75l113.8-59.71C281.4 443 288 432.1 288 420.2L287.9 25.05zM240 410.5l-76.61 40.2l22.4-130.1c.8952-5.2-.8309-10.51-4.614-14.19l-94.7-92.09l130.9-19.04c5.207-.7576 9.709-4.027 12.04-8.745l10.59-21.42V410.5z"],
    "sun": [512, 512, [9728], "f185", "M505.2 324.8l-47.73-68.78l47.75-68.81c7.359-10.62 8.797-24.12 3.844-36.06c-4.969-11.94-15.52-20.44-28.22-22.72l-82.39-14.88l-14.89-82.41c-2.281-12.72-10.76-23.25-22.69-28.22c-11.97-4.936-25.42-3.498-36.12 3.844L256 54.49L187.2 6.709C176.5-.6016 163.1-2.039 151.1 2.896c-11.92 4.971-20.4 15.5-22.7 28.19l-14.89 82.44L31.15 128.4C18.42 130.7 7.854 139.2 2.9 151.2C-2.051 163.1-.5996 176.6 6.775 187.2l47.73 68.78l-47.75 68.81c-7.359 10.62-8.795 24.12-3.844 36.06c4.969 11.94 15.52 20.44 28.22 22.72l82.39 14.88l14.89 82.41c2.297 12.72 10.78 23.25 22.7 28.22c11.95 4.906 25.44 3.531 36.09-3.844L256 457.5l68.83 47.78C331.3 509.7 338.8 512 346.3 512c4.906 0 9.859-.9687 14.56-2.906c11.92-4.969 20.4-15.5 22.7-28.19l14.89-82.44l82.37-14.88c12.73-2.281 23.3-10.78 28.25-22.75C514.1 348.9 512.6 335.4 505.2 324.8zM456.8 339.2l-99.61 18l-18 99.63L256 399.1L172.8 456.8l-18-99.63l-99.61-18L112.9 255.1L55.23 172.8l99.61-18l18-99.63L256 112.9l83.15-57.75l18.02 99.66l99.61 18L399.1 255.1L456.8 339.2zM256 143.1c-61.85 0-111.1 50.14-111.1 111.1c0 61.85 50.15 111.1 111.1 111.1s111.1-50.14 111.1-111.1C367.1 194.1 317.8 143.1 256 143.1zM256 319.1c-35.28 0-63.99-28.71-63.99-63.99S220.7 192 256 192s63.99 28.71 63.99 63.1S291.3 319.1 256 319.1z"],
    "thumbs-down": [512, 512, [61576, 128078], "f165", "M128 288V64.03c0-17.67-14.33-31.1-32-31.1H32c-17.67 0-32 14.33-32 31.1v223.1c0 17.67 14.33 31.1 32 31.1h64C113.7 320 128 305.7 128 288zM481.5 229.1c1.234-5.092 1.875-10.32 1.875-15.64c0-22.7-11.44-43.13-29.28-55.28c.4219-3.015 .6406-6.076 .6406-9.122c0-22.32-11.06-42.6-28.83-54.83c-2.438-34.71-31.47-62.2-66.8-62.2h-52.53c-35.94 0-71.55 11.87-100.3 33.41L169.6 92.93c-6.285 4.71-9.596 11.85-9.596 19.13c0 12.76 10.29 24.04 24.03 24.04c5.013 0 10.07-1.565 14.38-4.811l36.66-27.51c20.48-15.34 45.88-23.81 71.5-23.81h52.53c10.45 0 18.97 8.497 18.97 18.95c0 3.5-1.11 4.94-1.11 9.456c0 26.97 29.77 17.91 29.77 40.64c0 9.254-6.392 10.96-6.392 22.25c0 13.97 10.85 21.95 19.58 23.59c8.953 1.671 15.45 9.481 15.45 18.56c0 13.04-11.39 13.37-11.39 28.91c0 12.54 9.702 23.08 22.36 23.94C456.2 266.1 464 275.2 464 284.1c0 10.43-8.516 18.93-18.97 18.93H307.4c-12.44 0-24 10.02-24 23.1c0 4.038 1.02 8.078 3.066 11.72C304.4 371.7 312 403.8 312 411.2c0 8.044-5.984 20.79-22.06 20.79c-12.53 0-14.27-.9059-24.94-28.07c-24.75-62.91-61.74-99.9-80.98-99.9c-13.8 0-24.02 11.27-24.02 23.99c0 7.041 3.083 14.02 9.016 18.76C238.1 402 211.4 480 289.9 480C333.8 480 360 445 360 411.2c0-12.7-5.328-35.21-14.83-59.33h99.86C481.1 351.9 512 321.9 512 284.1C512 261.8 499.9 241 481.5 229.1z"],
    "thumbs-up": [512, 512, [61575, 128077], "f164", "M96 191.1H32c-17.67 0-32 14.33-32 31.1v223.1c0 17.67 14.33 31.1 32 31.1h64c17.67 0 32-14.33 32-31.1V223.1C128 206.3 113.7 191.1 96 191.1zM512 227c0-36.89-30.05-66.92-66.97-66.92h-99.86C354.7 135.1 360 113.5 360 100.8c0-33.8-26.2-68.78-70.06-68.78c-46.61 0-59.36 32.44-69.61 58.5c-31.66 80.5-60.33 66.39-60.33 93.47c0 12.84 10.36 23.99 24.02 23.99c5.256 0 10.55-1.721 14.97-5.26c76.76-61.37 57.97-122.7 90.95-122.7c16.08 0 22.06 12.75 22.06 20.79c0 7.404-7.594 39.55-25.55 71.59c-2.046 3.646-3.066 7.686-3.066 11.72c0 13.92 11.43 23.1 24 23.1h137.6C455.5 208.1 464 216.6 464 227c0 9.809-7.766 18.03-17.67 18.71c-12.66 .8593-22.36 11.4-22.36 23.94c0 15.47 11.39 15.95 11.39 28.91c0 25.37-35.03 12.34-35.03 42.15c0 11.22 6.392 13.03 6.392 22.25c0 22.66-29.77 13.76-29.77 40.64c0 4.515 1.11 5.961 1.11 9.456c0 10.45-8.516 18.95-18.97 18.95h-52.53c-25.62 0-51.02-8.466-71.5-23.81l-36.66-27.51c-4.315-3.245-9.37-4.811-14.38-4.811c-13.85 0-24.03 11.38-24.03 24.04c0 7.287 3.312 14.42 9.596 19.13l36.67 27.52C235 468.1 270.6 480 306.6 480h52.53c35.33 0 64.36-27.49 66.8-62.2c17.77-12.23 28.83-32.51 28.83-54.83c0-3.046-.2187-6.107-.6406-9.122c17.84-12.15 29.28-32.58 29.28-55.28c0-5.311-.6406-10.54-1.875-15.64C499.9 270.1 512 250.2 512 227z"],
    "trash-can": [448, 512, [61460, "trash-alt"], "f2ed", "M432 80h-82.38l-34-56.75C306.1 8.827 291.4 0 274.6 0H173.4C156.6 0 141 8.827 132.4 23.25L98.38 80H16C7.125 80 0 87.13 0 96v16C0 120.9 7.125 128 16 128H32v320c0 35.35 28.65 64 64 64h256c35.35 0 64-28.65 64-64V128h16C440.9 128 448 120.9 448 112V96C448 87.13 440.9 80 432 80zM171.9 50.88C172.9 49.13 174.9 48 177 48h94c2.125 0 4.125 1.125 5.125 2.875L293.6 80H154.4L171.9 50.88zM352 464H96c-8.837 0-16-7.163-16-16V128h288v320C368 456.8 360.8 464 352 464zM224 416c8.844 0 16-7.156 16-16V192c0-8.844-7.156-16-16-16S208 183.2 208 192v208C208 408.8 215.2 416 224 416zM144 416C152.8 416 160 408.8 160 400V192c0-8.844-7.156-16-16-16S128 183.2 128 192v208C128 408.8 135.2 416 144 416zM304 416c8.844 0 16-7.156 16-16V192c0-8.844-7.156-16-16-16S288 183.2 288 192v208C288 408.8 295.2 416 304 416z"],
    "user": [448, 512, [62144, 128100], "f007", "M272 304h-96C78.8 304 0 382.8 0 480c0 17.67 14.33 32 32 32h384c17.67 0 32-14.33 32-32C448 382.8 369.2 304 272 304zM48.99 464C56.89 400.9 110.8 352 176 352h96c65.16 0 119.1 48.95 127 112H48.99zM224 256c70.69 0 128-57.31 128-128c0-70.69-57.31-128-128-128S96 57.31 96 128C96 198.7 153.3 256 224 256zM224 48c44.11 0 80 35.89 80 80c0 44.11-35.89 80-80 80S144 172.1 144 128C144 83.89 179.9 48 224 48z"],
    "window-maximize": [512, 512, [128470], "f2d0", "M0 96v320c0 35.35 28.65 64 64 64h384c35.35 0 64-28.65 64-64v-320c0-35.35-28.65-63.1-64-63.1H64C28.65 32 0 60.65 0 96zM48 224h416v192c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V224z"],
    "window-minimize": [512, 512, [128469], "f2d1", "M480 480H32c-17.75 0-32-14.25-32-32s14.25-32 32-32h448c17.75 0 32 14.25 32 32S497.8 480 480 480z"],
    "window-restore": [512, 512, [], "f2d2", "M320 128H64c-35.35 0-64 28.65-64 64v256c0 35.35 28.65 64 64 64h256c35.35 0 64-28.65 64-64v-256C384 156.7 355.3 128 320 128zM336 448c0 8.824-7.178 16-16 16H64c-8.822 0-16-7.176-16-16V256h288V448zM448 .0001H192c-35.35 0-64 28.65-64 63.1V80h48V64c0-8.824 7.178-16 16-16h256c8.822 0 16 7.176 16 16v256c0 8.824-7.178 16-16 16h-16V384l16 .0001c35.35 0 64-28.65 64-64v-256C512 28.65 483.3 .0001 448 .0001z"]
  };

  bunker(function () {
    defineIcons('far', icons);
    defineIcons('fa-regular', icons);
  });

}());
