<?php
if (!isset($_SESSION)) session_start();
if (!isset($_SESSION['user'])) {
    header("Location: ../auth/login.php");
    exit;
}

$user = $_SESSION['user'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
<title>Pharmacy System</title>

<link rel="stylesheet" href="../libraries/bootstrap.css">
<link rel="stylesheet" href="../libraries/fontawesome-free-6.0.0-beta2-web/css/all.min.css">
<link rel="icon" href="../assets/img/favicon.jpg" type="image/x-icon">
<link rel="shortcut icon" href="../assets/img/favicon.jpg" type="image/x-icon">

<style>
/* ===============================
   GLOBAL
================================ */
body {
    font-family: Arial, sans-serif;
    background-color: #f5f7fb;
}

/* ===============================
   HEADER (PURPLE + BLUE THEME)
================================ */
.navbar-custom {
    background: linear-gradient(90deg, #4c1d95, #1e3a8a);
    padding: 12px 24px;
    box-shadow: 0 6px 18px rgba(0,0,0,0.2);
}

/* Logo */
.navbar-logo {
    width: 55px;
    height: 55px;
    border-radius: 50%;
    object-fit: cover;
    margin-right: 12px;
    box-shadow: 0 3px 8px rgba(0,0,0,0.35);
}

/* Brand text */
.navbar-brand {
    color: #ffffff !important;
    font-weight: 700;
    line-height: 1.2;
    text-align: center;
}

/* Subtitle */
.navbar-brand small {
    color: #c7d2fe;
    font-weight: 500;
    font-size: 12px;
}

/* User info */
.user-info {
    color: #e0e7ff;
    font-size: 14px;
    font-weight: 500;
}

/* Logout button */
.btn-logout {
    background: linear-gradient(135deg, #6d28d9, #2563eb);
    border: none;
    color: #fff;
    font-size: 13px;
    padding: 6px 14px;
    margin-left: 10px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.25);
}

.btn-logout:hover {
    opacity: 0.9;
}

/* Mobile toggle */
.navbar-toggler {
    border: none;
}

.navbar-toggler i {
    color: #ffffff;
    font-size: 22px;
}
</style>
</head>

<body>

<nav class="navbar navbar-expand-lg navbar-custom position-relative">

    <!-- CENTERED LOGO + TITLE -->
    <div class="d-flex align-items-center mx-auto">
        <img src="../assets/img/logo.jpg" alt="Logo" class="navbar-logo">

        <span class="navbar-brand mb-0 h4">
            Pharmacy Management Information System<br>
            <small>Multishop Management Software</small>
        </span>
    </div>

    <!-- MOBILE SIDEBAR TOGGLE -->
    <button class="navbar-toggler d-md-none position-absolute" 
            style="left: 15px;" 
            type="button" 
            data-toggle="collapse" 
            data-target="#sidebar">
        <i class="fas fa-bars"></i>
    </button>

    <!-- USER INFO -->
    <div class="d-none d-md-flex align-items-center position-absolute user-info" 
         style="right: 20px;">
        <span>
            Hello, <?= htmlspecialchars($user['fullname']) ?>
        </span>
        <a href="../auth/logout.php" class="btn btn-logout btn-sm">
            Logout
        </a>
    </div>

</nav>

<div class="container-fluid">
    <div class="row">
