<?php
class Database {
    private static $instance = null;
    private $connection;
    
    private function __construct() {
        try {
            $this->connection = new PDO(
                "mysql:host=127.0.0.1;dbname=pharmacy_db;charset=utf8mb4",
                "root",
                "", // Your MySQL password here
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
        } catch (PDOException $e) {
            die("Connection failed: " . $e->getMessage());
        }
    }
    
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new Database();
        }
        return self::$instance->connection;
    }
}

function getDatabaseConnection() {
    return Database::getInstance();
}

// Test connection (optional)
// try {
//     $db = getDatabaseConnection();
//     echo "Database connection successful!";
// } catch (PDOException $e) {
//     die("Database connection failed: " . $e->getMessage());
// }
?>